/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OperationTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.TradeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountRecordReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemAmountRecordVo;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlItemAmountRecordService;
import com.dtyunxi.tcbj.center.control.biz.service.impl.TrControlItemAmountRuleServiceImpl;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlItemAmountImportDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlItemAmountRecordDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlItemAmountRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlItemAmountRecordEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TrControlItemAmountRecordServiceImpl
implements ITrControlItemAmountRecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrControlItemAmountRuleServiceImpl.class);
    @Resource
    private TrControlItemAmountRecordDas trControlItemAmountRecordDas;
    @Resource
    private TrControlItemAmountImportDas trControlItemAmountImportDas;
    @Resource
    private TrControlItemAmountRuleDas trControlItemAmountRuleDas;

    @Override
    public Long addTrControlItemAmountRecord(TrControlItemAmountRecordReqDto addReqDto) {
        TrControlItemAmountRecordEo trControlItemAmountRecordEo = new TrControlItemAmountRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)trControlItemAmountRecordEo);
        this.trControlItemAmountRecordDas.insert((BaseEo)trControlItemAmountRecordEo);
        return trControlItemAmountRecordEo.getId();
    }

    @Override
    public void modifyTrControlItemAmountRecord(TrControlItemAmountRecordReqDto modifyReqDto) {
        TrControlItemAmountRecordEo trControlItemAmountRecordEo = new TrControlItemAmountRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)trControlItemAmountRecordEo);
        this.trControlItemAmountRecordDas.updateSelective((BaseEo)trControlItemAmountRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTrControlItemAmountRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.trControlItemAmountRecordDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public TrControlItemAmountRecordRespDto queryById(Long id) {
        TrControlItemAmountRecordEo trControlItemAmountRecordEo = (TrControlItemAmountRecordEo)this.trControlItemAmountRecordDas.selectByPrimaryKey(id);
        TrControlItemAmountRecordRespDto trControlItemAmountRecordRespDto = new TrControlItemAmountRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)trControlItemAmountRecordEo, (BaseVo)trControlItemAmountRecordRespDto);
        return trControlItemAmountRecordRespDto;
    }

    @Override
    public PageInfo<TrControlItemAmountRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TrControlItemAmountRecordReqDto trControlItemAmountRecordReqDto = (TrControlItemAmountRecordReqDto)JSON.parseObject((String)filter, TrControlItemAmountRecordReqDto.class);
        TrControlItemAmountRecordEo trControlItemAmountRecordEo = new TrControlItemAmountRecordEo();
        DtoHelper.dto2Eo((BaseVo)trControlItemAmountRecordReqDto, (BaseEo)trControlItemAmountRecordEo);
        AssertUtils.notNull((Object)trControlItemAmountRecordEo.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (!StringUtils.isEmpty((CharSequence)trControlItemAmountRecordReqDto.getAmountTime())) {
            trControlItemAmountRecordEo.setAmountTime(DateUtil.parseDate((String)trControlItemAmountRecordReqDto.getAmountTime(), (String)DatePattern.MONTH_PATTERN.getPattern()));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{trControlItemAmountRecordEo.getCustomerName()})) {
            trControlItemAmountRecordEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.like((String)"customer_name", (Object)trControlItemAmountRecordEo.getCustomerName())}));
            trControlItemAmountRecordEo.setCustomerName(null);
        }
        if (!ObjectUtils.isEmpty((Object)trControlItemAmountRecordReqDto.getTradeEndTime()) && !ObjectUtils.isEmpty((Object)trControlItemAmountRecordReqDto.getTradeStartTime())) {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.ge((String)"trade_time", (Object)trControlItemAmountRecordReqDto.getTradeStartTime()));
            sqlFilters.add(SqlFilter.le((String)"trade_time", (Object)trControlItemAmountRecordReqDto.getTradeEndTime()));
            trControlItemAmountRecordEo.setSqlFilters((List)sqlFilters);
        }
        trControlItemAmountRecordEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.trControlItemAmountRecordDas.selectPage((BaseEo)trControlItemAmountRecordEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TrControlItemAmountRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ItemAmountRecordVo> exportItemAmountRecord(Long orgId, Long billId) {
        List controlItemAmountRecordEos;
        TrControlItemAmountRecordEo trControlItemAmountRecordEo = new TrControlItemAmountRecordEo();
        trControlItemAmountRecordEo.setOrgId(orgId);
        if (!ObjectUtils.isEmpty((Object)billId)) {
            trControlItemAmountRecordEo.setBillId(billId);
        }
        if (CollectionUtils.isEmpty((Collection)(controlItemAmountRecordEos = this.trControlItemAmountRecordDas.select((BaseEo)trControlItemAmountRecordEo)))) {
            return null;
        }
        ArrayList itemAmountRuleEos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)controlItemAmountRecordEos, (Collection)itemAmountRuleEos, ItemAmountRecordVo.class);
        Map<String, List<TrControlItemAmountRecordEo>> collect = controlItemAmountRecordEos.stream().collect(Collectors.groupingBy(c -> c.getTradeNo()));
        itemAmountRuleEos.forEach(c -> {
            List controlItemAmountRecordEoList = collect.getOrDefault(c.getTradeNo(), Lists.newArrayList());
            if (!CollectionUtils.isEmpty((Collection)controlItemAmountRecordEoList)) {
                TrControlItemAmountRecordEo trControlItemAmountRecordEo1 = (TrControlItemAmountRecordEo)controlItemAmountRecordEoList.stream().findFirst().get();
                c.setOperationType(OperationTypeEnum.enumOf((Integer)trControlItemAmountRecordEo1.getOperationType()).getDesc());
                c.setTradeType(TradeTypeEnum.enumOf((Integer)trControlItemAmountRecordEo1.getTradeType()).getDesc());
            }
        });
        return itemAmountRuleEos;
    }

    @Override
    public TrControlItemAmountRecordRespDto queryRecordByOrderNo(String orderNo) {
        AssertUtils.notEmpty((String)orderNo, (String)"orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TrControlItemAmountRecordEo queryEo = new TrControlItemAmountRecordEo();
        queryEo.setBusinessId(orderNo);
        TrControlItemAmountRecordEo itemAmountRecordEo = (TrControlItemAmountRecordEo)this.trControlItemAmountRecordDas.selectOne((BaseEo)queryEo);
        if (itemAmountRecordEo == null) {
            return null;
        }
        TrControlItemAmountRecordRespDto itemAmountRecordRespDto = new TrControlItemAmountRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)itemAmountRecordEo, (BaseVo)itemAmountRecordRespDto);
        return itemAmountRecordRespDto;
    }
}

