/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.control.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.dto.constant.AbatementScopeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.AmountStatusEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.ExcelTemplateEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.ImportItemAmountReason;
import com.dtyunxi.tcbj.center.control.api.dto.constant.IsMonthSettleEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.ItemAmountChangeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OperationTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OrderAbatementWayEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.RuleExitClashEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.TradeTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlItemAmountInfoReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizControlItemAmountReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.BizImportDataReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountConfigReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.TrControlItemAmountRuleReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizChangeRuleResultRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizImportRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.BizItemAmountRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ItemAmountExportDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountConfigRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRecordRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.TrControlItemAmountRuleRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemAmountOptVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemAmountVo;
import com.dtyunxi.tcbj.center.control.api.dto.vo.ItemSurplusAmountVo;
import com.dtyunxi.tcbj.center.control.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.control.api.exception.ControlExceptionCode;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlItemAmountConfigService;
import com.dtyunxi.tcbj.center.control.biz.service.ITrControlItemAmountRuleService;
import com.dtyunxi.tcbj.center.control.biz.utils.AmountFlowHelper;
import com.dtyunxi.tcbj.center.control.biz.utils.ExcelHelper;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlItemAmountConfigDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlItemAmountRecordDas;
import com.dtyunxi.tcbj.center.control.dao.das.TrControlItemAmountRuleDas;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlItemAmountConfigEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlItemAmountRecordEo;
import com.dtyunxi.tcbj.center.control.dao.eo.TrControlItemAmountRuleEo;
import com.dtyunxi.tcbj.center.control.dao.mapper.TrControlItemAmountRuleMapper;
import com.dtyunxi.tcbj.center.control.dao.vo.ChangeAmountRuleVo;
import com.dtyunxi.tcbj.center.control.dao.vo.CustomerAmountQueryVo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.sun.istack.NotNull;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@RefreshScope
public class TrControlItemAmountRuleServiceImpl
implements ITrControlItemAmountRuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrControlItemAmountRuleServiceImpl.class);
    @Resource
    private ExcelHelper excelHelper;
    @Resource
    private IContext context;
    @Resource
    private TrControlItemAmountRuleDas trControlItemAmountRuleDas;
    @Resource
    private ITrControlItemAmountConfigService trControlItemAmountConfigService;
    @Resource
    private TrControlItemAmountConfigDas controlItemAmountConfigDas;
    @Resource
    private TrControlItemAmountRecordDas itemAmountRecordDas;
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private ITrControlItemAmountRuleService controlItemAmountRuleService;
    @Resource
    private TrControlItemAmountRuleMapper trControlItemAmountRuleMapper;
    private final ThreadPoolExecutor importExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 4, 120L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(3, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizChangeRuleResultRespDto<Object, Object, TrControlItemAmountRuleReqDto> addTrControlItemAmountRule(BizControlItemAmountReqDto addReqDto) {
        BizChangeRuleResultRespDto<Object, Object, TrControlItemAmountRuleReqDto> bizChangeRuleResultRespDto = this.verifyRule(addReqDto);
        if (bizChangeRuleResultRespDto.getIsExistClash().equals(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue())) {
            return bizChangeRuleResultRespDto;
        }
        String nowMonth = DateUtil.formatDate((DatePattern)DatePattern.MONTH_PATTERN, (Date)new Date());
        ArrayList trControlItemAmountRuleEo = Lists.newArrayList();
        addReqDto.getItemAmountList().forEach(c -> c.getAmountInfoReqDtoList().forEach(k -> {
            TrControlItemAmountRuleEo itemAmountRuleEo = new TrControlItemAmountRuleEo();
            DtoHelper.dto2Eo((BaseVo)c, (BaseEo)itemAmountRuleEo);
            Date AmountTime = DateUtil.parseDate((String)k.getAmountTime(), (String)DatePattern.MONTH_PATTERN.getPattern());
            itemAmountRuleEo.setAmountTime(AmountTime);
            itemAmountRuleEo.setIsMonthSettle(k.getIsMonthSettle());
            int compareToResult = DateUtil.parseDate((String)nowMonth, (String)DatePattern.MONTH_PATTERN.getPattern()).compareTo(AmountTime);
            itemAmountRuleEo.setStatus(compareToResult < 0 ? AmountStatusEnum.USE.getType() : (compareToResult == 0 ? AmountStatusEnum.USING.getType() : AmountStatusEnum.USED.getType()));
            trControlItemAmountRuleEo.add(itemAmountRuleEo);
        }));
        LOGGER.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u3011\u6279\u91cf\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)trControlItemAmountRuleEo));
        int result = this.trControlItemAmountRuleDas.insertBatch((List)trControlItemAmountRuleEo);
        if (result < 0) {
            LOGGER.error("\u3010\u8ba2\u8d27\u989d\u5ea6\u3011\u6279\u91cf\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)trControlItemAmountRuleEo));
            throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
        }
        trControlItemAmountRuleEo.forEach(c -> {
            TrControlItemAmountRuleReqDto trControlItemAmountRuleReqDto = addReqDto.getItemAmountList().stream().filter(k -> c.getCustomerCode().equals(k.getCustomerCode())).findFirst().get();
            BizControlItemAmountInfoReqDto bizControlItemAmountInfoReqDto = trControlItemAmountRuleReqDto.getAmountInfoReqDtoList().stream().filter(v -> DateUtil.parseDate((String)v.getAmountTime(), (String)DatePattern.MONTH_PATTERN.getPattern()).equals(c.getAmountTime())).findFirst().get();
            TradeTypeEnum tradeTypeEnum = TradeTypeEnum.AMOUNT_MONTH;
            ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo(c.getId(), bizControlItemAmountInfoReqDto.getMonthAmount(), tradeTypeEnum, c.getCustomerCode(), c.getCustomerName(), c.getAmountTime(), null, null, c.getOrgId());
            this.controlItemAmountRuleService.handleAmount(itemAmountOptVo);
        });
        TrControlItemAmountConfigRespDto trControlItemAmountConfigRespDto = this.trControlItemAmountConfigService.queryByOrgId(((TrControlItemAmountRuleReqDto)addReqDto.getItemAmountList().get(0)).getOrgId());
        if (ObjectUtils.isEmpty((Object)trControlItemAmountConfigRespDto)) {
            TrControlItemAmountConfigReqDto reqDto = new TrControlItemAmountConfigReqDto();
            reqDto.setOrgId(((TrControlItemAmountRuleReqDto)addReqDto.getItemAmountList().get(0)).getOrgId());
            reqDto.setOrderDeductionScope(JSON.toJSONString(Arrays.asList(AbatementScopeEnum.PRODUCT.getType(), AbatementScopeEnum.GIFT.getType())));
            reqDto.setOrderDeductionWay(OrderAbatementWayEnum.SUPPLY_PRICE.getType());
            LOGGER.info("\u3010\u8ba2\u8d27\u989d\u5ea6\u3011\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
            int config_result = this.trControlItemAmountConfigService.addTrControlItemAmountConfig(reqDto);
            if (config_result < 0) {
                LOGGER.error("\u3010\u8ba2\u8d27\u989d\u5ea6\u3011\u6279\u91cf\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)trControlItemAmountRuleEo));
                throw ControlExceptionCode.INSERT_BATCH_FAIL.getException();
            }
        }
        return bizChangeRuleResultRespDto;
    }

    public BizChangeRuleResultRespDto<Object, Object, TrControlItemAmountRuleReqDto> verifyRule(BizControlItemAmountReqDto addReqDto) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        BizChangeRuleResultRespDto bizChangeRuleResultRespDto = new BizChangeRuleResultRespDto();
        Map<String, List<TrControlItemAmountRuleReqDto>> collect = addReqDto.getItemAmountList().stream().collect(Collectors.groupingBy(c -> c.getCustomerCode()));
        collect.forEach((k, v) -> {
            TrControlItemAmountRuleReqDto trControlItemAmountRuleReqDto = (TrControlItemAmountRuleReqDto)v.stream().findFirst().get();
            List amountTime = trControlItemAmountRuleReqDto.getAmountInfoReqDtoList().stream().map(c -> DateUtil.parseDate((String)c.getAmountTime(), (String)DatePattern.MONTH_PATTERN.getPattern())).collect(Collectors.toList());
            TrControlItemAmountRuleEo itemAmountRuleEo = new TrControlItemAmountRuleEo();
            itemAmountRuleEo.setCustomerCode(k);
            itemAmountRuleEo.setOrgId(trControlItemAmountRuleReqDto.getOrgId());
            itemAmountRuleEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"amount_time", amountTime)}));
            List itemAmountRuleEos = this.trControlItemAmountRuleDas.select((BaseEo)itemAmountRuleEo);
            if (!ObjectUtils.isEmpty((Object)itemAmountRuleEos)) {
                LOGGER.error("\u3010\u8ba2\u8d27\u989d\u5ea6\u3011\uff1a\u5f53\u524d\u5ba2\u6237\uff1a{} \u5df2\u5b58\u5728\u5f53\u524d\u8bbe\u7f6e\u6708\u4efd\u7684\u8ba2\u8d27\u989d\u5ea6\uff1a{}", k, (Object)JSON.toJSONString((Object)itemAmountRuleEos));
                ArrayList controlItemAmountRuleReqDtos = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)itemAmountRuleEos, (Collection)controlItemAmountRuleReqDtos, TrControlItemAmountRuleReqDto.class);
                Map<Long, TrControlItemAmountRuleReqDto> collect1 = controlItemAmountRuleReqDtos.stream().collect(Collectors.toMap(TrControlItemAmountRuleReqDto::getId, c -> c));
                itemAmountRuleEos.stream().forEach(c -> {
                    if (!ObjectUtils.isEmpty((Object)c.getAmountTime())) {
                        TrControlItemAmountRuleReqDto controlItemAmountRuleReqDto = collect1.getOrDefault(c.getId(), null);
                        controlItemAmountRuleReqDto.setAmountTime(simpleDateFormat.format(c.getAmountTime()));
                    }
                });
                bizChangeRuleResultRespDto.setIsExistClash(RuleExitClashEnum.RULEEXITCLASHENUM_EXIT.getValue());
                bizChangeRuleResultRespDto.setConflictRuleList((List)controlItemAmountRuleReqDtos);
            }
        });
        return bizChangeRuleResultRespDto;
    }

    @Override
    public void modifyTrControlItemAmountRule(TrControlItemAmountRuleReqDto modifyReqDto) {
        TrControlItemAmountRuleEo trControlItemAmountRuleEo = new TrControlItemAmountRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)trControlItemAmountRuleEo);
        this.trControlItemAmountRuleDas.updateSelective((BaseEo)trControlItemAmountRuleEo);
    }

    @Override
    public void modifyItemAmount(TrControlItemAmountRuleReqDto modifyReqDto) {
        TradeTypeEnum tradeTypeEnum = ItemAmountChangeTypeEnum.ADD.getType().equals(modifyReqDto.getChangeType()) ? TradeTypeEnum.AMOUNT_ADD : TradeTypeEnum.AMOUNT_CUT;
        ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo(modifyReqDto.getId(), modifyReqDto.getChangeAmount(), tradeTypeEnum, modifyReqDto.getCustomerCode(), modifyReqDto.getCustomerName(), DateUtil.parseDate((String)modifyReqDto.getAmountTime(), (String)"yyyy\u5e74MM\u6708"), null, null, modifyReqDto.getOrgId());
        this.controlItemAmountRuleService.handleAmount(itemAmountOptVo);
        TrControlItemAmountRuleEo trControlItemAmountRuleEo = new TrControlItemAmountRuleEo();
        trControlItemAmountRuleEo.setId(modifyReqDto.getId());
        trControlItemAmountRuleEo.setIsMonthSettle(modifyReqDto.getIsMonthSettle());
        this.trControlItemAmountRuleDas.updateSelective((BaseEo)trControlItemAmountRuleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTrControlItemAmountRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.trControlItemAmountRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public TrControlItemAmountRuleRespDto queryById(Long id) {
        TrControlItemAmountRuleEo trControlItemAmountRuleEo = (TrControlItemAmountRuleEo)this.trControlItemAmountRuleDas.selectByPrimaryKey(id);
        TrControlItemAmountRuleRespDto trControlItemAmountRuleRespDto = new TrControlItemAmountRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)trControlItemAmountRuleEo, (BaseVo)trControlItemAmountRuleRespDto);
        if (!ObjectUtils.isEmpty((Object)trControlItemAmountRuleEo.getAmountTime())) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708");
            trControlItemAmountRuleRespDto.setAmountTime(simpleDateFormat.format(trControlItemAmountRuleEo.getAmountTime()));
        }
        return trControlItemAmountRuleRespDto;
    }

    @Override
    public PageInfo<TrControlItemAmountRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        JSONObject jsonObject = JSON.parseObject((String)filter);
        TrControlItemAmountRuleReqDto trControlItemAmountRuleReqDto = (TrControlItemAmountRuleReqDto)JSON.parseObject((String)jsonObject.toJSONString(), TrControlItemAmountRuleReqDto.class);
        TrControlItemAmountRuleEo trControlItemAmountRuleEo = new TrControlItemAmountRuleEo();
        DtoHelper.dto2Eo((BaseVo)trControlItemAmountRuleReqDto, (BaseEo)trControlItemAmountRuleEo);
        AssertUtils.notNull((Object)trControlItemAmountRuleEo.getOrgId(), (String)"\u7ec4\u7ec7id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (!StringUtils.isEmpty((CharSequence)trControlItemAmountRuleReqDto.getAmountTime())) {
            trControlItemAmountRuleEo.setAmountTime(DateUtil.parseDate((String)trControlItemAmountRuleReqDto.getAmountTime(), (String)DatePattern.MONTH_PATTERN.getPattern()));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{trControlItemAmountRuleEo.getCustomerName()})) {
            trControlItemAmountRuleEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.like((String)"customer_name", (Object)trControlItemAmountRuleEo.getCustomerName())}));
            trControlItemAmountRuleEo.setCustomerName(null);
        }
        trControlItemAmountRuleEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.trControlItemAmountRuleDas.selectPage((BaseEo)trControlItemAmountRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TrControlItemAmountRuleRespDto.class);
        Map<Long, TrControlItemAmountRuleRespDto> collect1 = dtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, c -> c));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708");
        eoPageInfo.getList().stream().forEach(c -> {
            if (!ObjectUtils.isEmpty((Object)c.getAmountTime())) {
                TrControlItemAmountRuleRespDto controlItemAmountRuleRespDto = collect1.getOrDefault(c.getId(), null);
                controlItemAmountRuleRespDto.setAmountTime(simpleDateFormat.format(c.getAmountTime()));
            }
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BizImportRespDto importByExcel(BizImportDataReqDto<ItemAmountVo> bizImportDataReqDto) {
        try {
            List importVoList = bizImportDataReqDto.getExcelImportResult();
            Integer total = importVoList.size();
            Integer importSuccessTotal = 0;
            Integer importFailTotal = 0;
            ArrayList exportVoList = Lists.newArrayList();
            List amountTime = importVoList.stream().map(c -> DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)DateUtil.getMonthBegin((Date)c.getAmountTime()))).distinct().collect(Collectors.toList());
            List customerCodeList = importVoList.stream().map(c -> c.getCode()).distinct().collect(Collectors.toList());
            TrControlItemAmountRuleEo trControlItemAmountRuleEo = new TrControlItemAmountRuleEo();
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"customer_code", customerCodeList));
            sqlFilters.add(SqlFilter.in((String)"amount_time", amountTime));
            trControlItemAmountRuleEo.setSqlFilters((List)sqlFilters);
            trControlItemAmountRuleEo.setOrgId(bizImportDataReqDto.getOrgId());
            List itemAmountRuleEos = this.trControlItemAmountRuleDas.select((BaseEo)trControlItemAmountRuleEo);
            Map<String, List<TrControlItemAmountRuleEo>> collect = itemAmountRuleEos.stream().collect(Collectors.groupingBy(c -> c.getCustomerCode() + DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)c.getAmountTime())));
            HashMap<String, TrControlItemAmountRuleEo> recordMap = new HashMap<String, TrControlItemAmountRuleEo>();
            for (ItemAmountVo itemAmountVo : importVoList) {
                Integer n;
                Integer n2;
                ItemAmountVo resultItemAmountVo = this.authImportMonthAmountData(itemAmountVo, bizImportDataReqDto.getOrgId(), bizImportDataReqDto.getTenantId());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resultItemAmountVo.getReason()})) {
                    n2 = importFailTotal;
                    n = importFailTotal = Integer.valueOf(importFailTotal + 1);
                    exportVoList.add(resultItemAmountVo);
                    continue;
                }
                n2 = importSuccessTotal;
                n = importSuccessTotal = Integer.valueOf(importSuccessTotal + 1);
                List<TrControlItemAmountRuleEo> orDefault = collect.getOrDefault(itemAmountVo.getCode() + DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)itemAmountVo.getAmountTime()), Lists.newArrayList());
                TrControlItemAmountRuleEo recordMapOrDefault = recordMap.getOrDefault(itemAmountVo.getCode() + itemAmountVo.getAmountTime().getTime(), null);
                if (CollectionUtils.isEmpty(orDefault) && ObjectUtils.isEmpty((Object)recordMapOrDefault)) {
                    TrControlItemAmountRuleEo itemAmountRuleEo = this.batchInsert(itemAmountVo, bizImportDataReqDto.getOrgId(), bizImportDataReqDto.getImportId());
                    recordMap.put(itemAmountVo.getCode() + itemAmountVo.getAmountTime().getTime(), itemAmountRuleEo);
                    continue;
                }
                IsMonthSettleEnum isMonthSettleEnum = Arrays.stream(IsMonthSettleEnum.values()).filter(v -> v.getDesc().equals(itemAmountVo.getIsMonthSettle())).findFirst().get();
                TrControlItemAmountRuleEo itemAmountRuleEo = !ObjectUtils.isEmpty((Object)recordMapOrDefault) ? recordMapOrDefault : (TrControlItemAmountRuleEo)orDefault.stream().findFirst().get();
                TrControlItemAmountRuleEo updateItemAmountRuleEo = new TrControlItemAmountRuleEo();
                updateItemAmountRuleEo.setIsMonthSettle(isMonthSettleEnum.getType());
                updateItemAmountRuleEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"id", (Object)itemAmountRuleEo.getId())}));
                this.trControlItemAmountRuleDas.updateSelectiveSqlFilter((BaseEo)updateItemAmountRuleEo);
                BigDecimal amount = new BigDecimal(itemAmountVo.getAmount());
                TradeTypeEnum tradeTypeEnum = amount.compareTo(BigDecimal.ZERO) == -1 ? TradeTypeEnum.AMOUNT_CUT : TradeTypeEnum.AMOUNT_ADD;
                ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo(itemAmountRuleEo.getId(), amount.compareTo(BigDecimal.ZERO) == -1 ? amount.negate() : amount, tradeTypeEnum, itemAmountRuleEo.getCustomerCode(), itemAmountRuleEo.getCustomerName(), itemAmountRuleEo.getAmountTime(), null, bizImportDataReqDto.getImportId(), bizImportDataReqDto.getOrgId());
                this.controlItemAmountRuleService.handleAmount(itemAmountOptVo);
            }
            String url = null;
            if (!ObjectUtils.isEmpty((Object)exportVoList)) {
                LOGGER.info("\u6821\u9a8c\u5f02\u5e38\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)exportVoList));
                if (!ObjectUtils.isEmpty((Object)exportVoList)) {
                    String excelName = "cube/\u5bfc\u5165\u6708\u8ba2\u8d27\u989d\u5ea6\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
                    url = EasyPoiExportUtil.getExportUrl((List)exportVoList, ItemAmountVo.class, (String)null, (String)excelName, (String)"xls");
                }
            }
            return new BizImportRespDto(total, importSuccessTotal, importFailTotal, url);
        }
        catch (Exception var6) {
            var6.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
    }

    @Override
    public List<ItemAmountExportDto> exportItemAmountBatch(Long orgId) {
        TrControlItemAmountRuleEo itemAmountRuleEo = new TrControlItemAmountRuleEo();
        itemAmountRuleEo.setOrgId(orgId);
        List itemAmountRuleEos = this.trControlItemAmountRuleDas.select((BaseEo)itemAmountRuleEo);
        if (CollectionUtils.isEmpty((Collection)itemAmountRuleEos)) {
            return null;
        }
        ArrayList itemAmountExportDtos = Lists.newArrayList();
        Map<String, List<TrControlItemAmountRuleEo>> collect = itemAmountRuleEos.stream().collect(Collectors.groupingBy(c -> c.getCustomerCode() + c.getAmountTime()));
        DtoHelper.eoList2DtoList((Collection)itemAmountRuleEos, (Collection)itemAmountExportDtos, ItemAmountExportDto.class);
        itemAmountExportDtos.forEach(c -> {
            List controlItemAmountRuleEos = collect.getOrDefault(c.getCustomerCode() + c.getAmountTime(), Lists.newArrayList());
            if (!CollectionUtils.isEmpty((Collection)controlItemAmountRuleEos)) {
                TrControlItemAmountRuleEo itemAmountRuleEo1 = (TrControlItemAmountRuleEo)controlItemAmountRuleEos.stream().findFirst().get();
                c.setStatus(AmountStatusEnum.enumOf((Integer)itemAmountRuleEo1.getStatus()).getDesc());
                c.setIsMonthSettle(IsMonthSettleEnum.enumOf((Integer)itemAmountRuleEo1.getIsMonthSettle()).getDesc());
            }
        });
        return itemAmountExportDtos;
    }

    public TrControlItemAmountRuleEo batchInsert(ItemAmountVo itemAmountVo, Long orgId, Long importId) {
        if (ObjectUtils.isEmpty((Object)itemAmountVo)) {
            return null;
        }
        String nowMonth = DateUtil.formatDate((DatePattern)DatePattern.MONTH_PATTERN, (Date)new Date());
        Date date = DateUtil.parseDate((String)nowMonth, (String)DatePattern.MONTH_PATTERN.getPattern());
        int i = date.compareTo(itemAmountVo.getAmountTime());
        Integer status = i == -1 ? AmountStatusEnum.USE.getType() : (i == 0 ? AmountStatusEnum.USING.getType() : AmountStatusEnum.USED.getType());
        IsMonthSettleEnum isMonthSettleEnum = Arrays.stream(IsMonthSettleEnum.values()).filter(v -> v.getDesc().equals(itemAmountVo.getIsMonthSettle())).findFirst().get();
        TrControlItemAmountRuleEo controlItemAmountRuleEo = new TrControlItemAmountRuleEo(itemAmountVo.getCode(), itemAmountVo.getName(), itemAmountVo.getAmountTime(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, isMonthSettleEnum.getType(), status, orgId);
        this.trControlItemAmountRuleDas.insert((BaseEo)controlItemAmountRuleEo);
        BigDecimal sum = new BigDecimal(itemAmountVo.getAmount());
        TradeTypeEnum tradeTypeEnum = TradeTypeEnum.AMOUNT_MONTH;
        ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo(controlItemAmountRuleEo.getId(), sum, tradeTypeEnum, controlItemAmountRuleEo.getCustomerCode(), controlItemAmountRuleEo.getCustomerName(), controlItemAmountRuleEo.getAmountTime(), null, importId, controlItemAmountRuleEo.getOrgId());
        this.controlItemAmountRuleService.handleAmount(itemAmountOptVo);
        return controlItemAmountRuleEo;
    }

    public ItemAmountVo authImportMonthAmountData(ItemAmountVo itemAmountVo, Long orgId, Long tenantId) {
        try {
            long count;
            try {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{itemAmountVo.getCode()})) {
                    LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_01.getDesc());
                    itemAmountVo.setReason(ImportItemAmountReason.ERROR_01.getDesc());
                    return itemAmountVo;
                }
                CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                customerSearchReqDto.setTenantId(tenantId);
                customerSearchReqDto.setCode(itemAmountVo.getCode());
                customerSearchReqDto.setMerchantId(orgId);
                RestResponse pageInfoRestResponse = this.iCustomerQueryApi.queryByPageOnPost(customerSearchReqDto, Integer.valueOf(1), Integer.valueOf(1));
                PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
                LOGGER.info("\u3010\u89e3\u6790\u5bfc\u5165\u7528\u6237\u3011\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfoRestResponse));
                AssertUtils.notEmpty((Collection)customerRespDtoPageInfo.getList(), (String)"\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
                CustomerRespDto data = (CustomerRespDto)customerRespDtoPageInfo.getList().stream().findFirst().get();
                AssertUtils.notNull((Object)data, (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38");
                AssertUtils.isTrue((boolean)data.getMerchantId().equals(orgId), (String)"\u5f53\u524d\u5ba2\u6237\u975e\u5f53\u524d\u7ec4\u7ec7");
                itemAmountVo.setName(StringUtils.defaultString((String)data.getName(), (String)""));
            }
            catch (Exception e) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_01.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_01.getDesc());
                return itemAmountVo;
            }
            boolean result = itemAmountVo.getAmountTime() instanceof Date;
            if (!result) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_07.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_07.getDesc());
                return itemAmountVo;
            }
            Date dayBegin = DateUtil.getMonthBegin((Date)itemAmountVo.getAmountTime());
            itemAmountVo.setAmountTime(dayBegin);
            if (ObjectUtils.isEmpty((Object)itemAmountVo.getAmount())) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_03.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_03.getDesc());
                return itemAmountVo;
            }
            BigDecimal changeAmount = new BigDecimal(itemAmountVo.getAmount());
            TrControlItemAmountRuleEo trControlItemAmountRuleEo = new TrControlItemAmountRuleEo();
            trControlItemAmountRuleEo.setCustomerCode(itemAmountVo.getCode());
            trControlItemAmountRuleEo.setAmountTime(itemAmountVo.getAmountTime());
            trControlItemAmountRuleEo.setOrgId(orgId);
            TrControlItemAmountRuleEo itemAmountRuleEos = (TrControlItemAmountRuleEo)this.trControlItemAmountRuleDas.selectOne((BaseEo)trControlItemAmountRuleEo);
            if (ObjectUtils.isEmpty((Object)itemAmountRuleEos)) {
                if (changeAmount.compareTo(BigDecimal.ZERO) == -1) {
                    LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_08.getDesc());
                    itemAmountVo.setReason(ImportItemAmountReason.ERROR_08.getDesc());
                    return itemAmountVo;
                }
            } else if (changeAmount.add(itemAmountRuleEos.getSurplusAmount()).compareTo(BigDecimal.ZERO) == -1) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_04.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_04.getDesc());
                return itemAmountVo;
            }
            if ((count = Arrays.stream(IsMonthSettleEnum.values()).filter(v -> v.getDesc().equals(itemAmountVo.getIsMonthSettle())).count()) == 0L) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_06.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_06.getDesc());
                return itemAmountVo;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_03.getDesc());
            itemAmountVo.setReason(ImportItemAmountReason.ERROR_03.getDesc());
            return itemAmountVo;
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_02.getDesc());
            itemAmountVo.setReason(ImportItemAmountReason.ERROR_02.getDesc());
            return itemAmountVo;
        }
        return itemAmountVo;
    }

    @Override
    public BizImportRespDto importSurplusAmountVoByExcel(BizImportDataReqDto<ItemSurplusAmountVo> bizImportDataReqDto) {
        List importVoList = bizImportDataReqDto.getExcelImportResult();
        AtomicReference<Integer> importFailTotal = new AtomicReference<Integer>(0);
        AtomicReference<Integer> importSuccessTotal = new AtomicReference<Integer>(0);
        Integer total = importVoList.size();
        ArrayList exportVoList = Lists.newArrayList();
        List<TrControlItemAmountRuleEo> itemAmountRuleEos = this.getTrControlItemAmountRuleEos(bizImportDataReqDto, importVoList);
        Map<String, List<TrControlItemAmountRuleEo>> collect = itemAmountRuleEos.stream().collect(Collectors.groupingBy(c -> c.getCustomerCode() + DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)c.getAmountTime())));
        ArrayList<TrControlItemAmountRecordRespDto> recordRespDtos = new ArrayList<TrControlItemAmountRecordRespDto>(importVoList.size());
        int limit = 500;
        int count = (importVoList.size() + limit - 1) / limit;
        Stream.iterate(0, n -> n + 1).limit(count).forEach(c -> this.batchImportHandler(bizImportDataReqDto, importVoList, importFailTotal, importSuccessTotal, exportVoList, collect, (List<TrControlItemAmountRecordRespDto>)recordRespDtos, limit, (Integer)c));
        this.createFlowBatch(recordRespDtos);
        String url = "";
        LOGGER.info("\u6821\u9a8c\u5f02\u5e38\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)exportVoList));
        if (!ObjectUtils.isEmpty((Object)exportVoList)) {
            String excelName = "cube/\u5bfc\u5165\u5269\u4f59\u989d\u5ea6\u5931\u8d25\u6587\u4ef6_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            url = EasyPoiExportUtil.getExportUrl((List)exportVoList, ItemSurplusAmountVo.class, (String)null, (String)excelName, (String)"xls");
        }
        return new BizImportRespDto(total, importSuccessTotal.get(), importFailTotal.get(), url);
    }

    private void batchImportHandler(BizImportDataReqDto<ItemSurplusAmountVo> bizImportDataReqDto, List<ItemSurplusAmountVo> importVoList, AtomicReference<Integer> importFailTotal, AtomicReference<Integer> importSuccessTotal, List<ItemSurplusAmountVo> exportVoList, Map<String, List<TrControlItemAmountRuleEo>> collect, List<TrControlItemAmountRecordRespDto> recordRespDtos, int limit, Integer c) {
        List<ItemSurplusAmountVo> amountVos = importVoList.stream().skip((long)c.intValue() * (long)limit).limit(limit).collect(Collectors.toList());
        ArrayList recordFutureList = new ArrayList(limit);
        amountVos.forEach(itemSurplusAmountVo -> this.checkAndRun(bizImportDataReqDto, importFailTotal, importSuccessTotal, exportVoList, collect, recordFutureList, (ItemSurplusAmountVo)itemSurplusAmountVo));
        CompletableFuture.allOf(recordFutureList.toArray(new CompletableFuture[0]));
        recordRespDtos.addAll(recordFutureList.stream().map(future -> {
            try {
                TrControlItemAmountRecordRespDto respDto = (TrControlItemAmountRecordRespDto)future.get();
                if (respDto.isFail()) {
                    ItemSurplusAmountVo amountVo = new ItemSurplusAmountVo();
                    BeanUtil.copyProperties((Object)respDto, (Object)amountVo, (String[])new String[0]);
                    exportVoList.add(amountVo);
                    return null;
                }
                return respDto;
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private List<TrControlItemAmountRuleEo> getTrControlItemAmountRuleEos(BizImportDataReqDto<ItemSurplusAmountVo> bizImportDataReqDto, List<ItemSurplusAmountVo> importVoList) {
        List customerCodeList = importVoList.stream().map(ItemSurplusAmountVo::getCode).collect(Collectors.toList());
        List amountTime = importVoList.stream().map(c -> DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)DateUtil.getMonthBegin((Date)c.getAmountTime()))).distinct().collect(Collectors.toList());
        TrControlItemAmountRuleEo trControlItemAmountRuleEo = new TrControlItemAmountRuleEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"customer_code", customerCodeList));
        sqlFilters.add(SqlFilter.in((String)"amount_time", amountTime));
        trControlItemAmountRuleEo.setSqlFilters((List)sqlFilters);
        trControlItemAmountRuleEo.setOrgId(bizImportDataReqDto.getOrgId());
        return this.trControlItemAmountRuleDas.select((BaseEo)trControlItemAmountRuleEo);
    }

    private void checkAndRun(BizImportDataReqDto<ItemSurplusAmountVo> bizImportDataReqDto, AtomicReference<Integer> importFailTotal, AtomicReference<Integer> importSuccessTotal, List<ItemSurplusAmountVo> exportVoList, Map<String, List<TrControlItemAmountRuleEo>> collect, List<CompletableFuture<TrControlItemAmountRecordRespDto>> recordFutureList, ItemSurplusAmountVo itemSurplusAmountVo) {
        this.authImportSurplusAmountData(itemSurplusAmountVo, bizImportDataReqDto.getOrgId(), bizImportDataReqDto.getTenantId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{itemSurplusAmountVo.getReason()})) {
            importFailTotal.getAndSet(importFailTotal.get() + 1);
            exportVoList.add(itemSurplusAmountVo);
        } else {
            importSuccessTotal.getAndSet(importSuccessTotal.get() + 1);
            recordFutureList.add(CompletableFuture.supplyAsync(() -> {
                TrControlItemAmountRuleEo controlItemAmountRuleEo = (TrControlItemAmountRuleEo)((List)collect.get(itemSurplusAmountVo.getCode() + DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)itemSurplusAmountVo.getAmountTime()))).stream().findFirst().get();
                ItemAmountOptVo itemAmountOptVo = new ItemAmountOptVo();
                itemAmountOptVo.setAmount(new BigDecimal(itemSurplusAmountVo.getAmount()));
                itemAmountOptVo.setId(controlItemAmountRuleEo.getId());
                itemAmountOptVo.setTypeEnum(TradeTypeEnum.AMOUNT_PERSON);
                itemAmountOptVo.setOrgId(bizImportDataReqDto.getOrgId());
                itemAmountOptVo.setCustomerName(controlItemAmountRuleEo.getCustomerName());
                itemAmountOptVo.setCustomerCode(controlItemAmountRuleEo.getCustomerCode());
                itemAmountOptVo.setAmountTime(controlItemAmountRuleEo.getAmountTime());
                itemAmountOptVo.setImportId(bizImportDataReqDto.getImportId());
                return this.controlItemAmountRuleService.handleAmountBatch(itemAmountOptVo);
            }, this.importExecutor));
        }
    }

    public ItemSurplusAmountVo authImportSurplusAmountData(ItemSurplusAmountVo itemAmountVo, Long orgId, Long tenantId) {
        try {
            try {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{itemAmountVo.getCode()})) {
                    LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_01.getDesc());
                    itemAmountVo.setReason(ImportItemAmountReason.ERROR_01.getDesc());
                    return itemAmountVo;
                }
                CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                customerSearchReqDto.setTenantId(tenantId);
                customerSearchReqDto.setCode(itemAmountVo.getCode());
                customerSearchReqDto.setMerchantId(orgId);
                RestResponse pageInfoRestResponse = this.iCustomerQueryApi.queryByPageOnPost(customerSearchReqDto, Integer.valueOf(1), Integer.valueOf(1));
                PageInfo customerRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
                LOGGER.info("\u3010\u5bfc\u5165\u8d60\u54c1\u989d\u5ea6\u989d\u5ea6\u3011\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)pageInfoRestResponse));
                AssertUtils.notEmpty((Collection)customerRespDtoPageInfo.getList(), (String)"\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
                CustomerRespDto data = (CustomerRespDto)customerRespDtoPageInfo.getList().stream().findFirst().get();
                AssertUtils.notNull((Object)data, (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38");
                AssertUtils.isTrue((boolean)data.getMerchantId().equals(orgId), (String)"\u5f53\u524d\u5ba2\u6237\u975e\u5f53\u524d\u7ec4\u7ec7");
                itemAmountVo.setName(StringUtils.defaultString((String)data.getName(), (String)""));
            }
            catch (Exception e) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_01.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_01.getDesc());
                return itemAmountVo;
            }
            boolean result = itemAmountVo.getAmountTime() instanceof Date;
            if (!result) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_07.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_07.getDesc());
                return itemAmountVo;
            }
            Date dayBegin = DateUtil.getMonthBegin((Date)itemAmountVo.getAmountTime());
            itemAmountVo.setAmountTime(dayBegin);
            if (ObjectUtils.isEmpty((Object)itemAmountVo.getAmount())) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_08.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_08.getDesc());
                return itemAmountVo;
            }
            BigDecimal changeAmount = new BigDecimal(itemAmountVo.getAmount());
            TrControlItemAmountRuleEo trControlItemAmountRuleEo = new TrControlItemAmountRuleEo();
            trControlItemAmountRuleEo.setCustomerCode(itemAmountVo.getCode());
            trControlItemAmountRuleEo.setAmountTime(itemAmountVo.getAmountTime());
            trControlItemAmountRuleEo.setOrgId(orgId);
            TrControlItemAmountRuleEo itemAmountRuleEos = (TrControlItemAmountRuleEo)this.trControlItemAmountRuleDas.selectOne((BaseEo)trControlItemAmountRuleEo);
            if (ObjectUtils.isEmpty((Object)itemAmountRuleEos)) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_19.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_19.getDesc());
                return itemAmountVo;
            }
            if (changeAmount.add(itemAmountRuleEos.getSurplusAmount()).compareTo(itemAmountRuleEos.getAllAmount()) == 1) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_09.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_09.getDesc());
                return itemAmountVo;
            }
            if (changeAmount.add(itemAmountRuleEos.getSurplusAmount()).compareTo(BigDecimal.ZERO) == -1) {
                LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_10.getDesc());
                itemAmountVo.setReason(ImportItemAmountReason.ERROR_10.getDesc());
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_08.getDesc());
            itemAmountVo.setReason(ImportItemAmountReason.ERROR_08.getDesc());
            return itemAmountVo;
        }
        catch (Exception e) {
            LOGGER.error("\u3010\u6708\u8ba2\u8d27\u989d\u5ea6\u5bfc\u5165\u3011{}\u5f02\u5e38", (Object)ImportItemAmountReason.ERROR_02.getDesc());
            itemAmountVo.setReason(ImportItemAmountReason.ERROR_02.getDesc());
            return itemAmountVo;
        }
        return itemAmountVo;
    }

    @Override
    public BizItemAmountRuleRespDto queryRuleByCustomer(String customerCode, Long orgId) {
        AssertUtils.notNull((Object)customerCode, (String)"customerCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)orgId, (String)"orgId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)orgId, (String)"orgId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TrControlItemAmountConfigEo queryEo = new TrControlItemAmountConfigEo();
        queryEo.setOrgId(orgId);
        TrControlItemAmountConfigEo controlItemAmountConfigEo = (TrControlItemAmountConfigEo)this.controlItemAmountConfigDas.selectOne((BaseEo)queryEo);
        if (controlItemAmountConfigEo == null) {
            LOGGER.info("\u3010\u5ba2\u6237\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u67e5\u8be2\u3011\u5f53\u524d\u5ba2\u6237(customerCode={})\u6ca1\u6709\u914d\u7f6e\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u7684\u89c4\u5219\uff01", (Object)customerCode);
            return null;
        }
        Date monthBegin = DateUtil.getMonthBegin();
        Date monthEnd = DateUtil.getMonthEnd();
        CustomerAmountQueryVo queryVo = new CustomerAmountQueryVo();
        queryVo.setCustomerCode(customerCode);
        queryVo.setOrgId(orgId);
        queryVo.setMonthBegin(monthBegin);
        queryVo.setMonthEnd(monthEnd);
        TrControlItemAmountRuleEo itemAmountRuleEo = this.trControlItemAmountRuleDas.selectRuleByCustomerId(queryVo);
        if (itemAmountRuleEo == null) {
            LOGGER.info("\u3010\u5ba2\u6237\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u67e5\u8be2\u3011\u5f53\u524d\u5ba2\u6237(customerCode={})\u9002\u5408\u7684\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u7684\u89c4\u5219\uff01", (Object)customerCode);
            return null;
        }
        BizItemAmountRuleRespDto itemAmountRuleRespDto = new BizItemAmountRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)itemAmountRuleEo, (BaseVo)itemAmountRuleRespDto);
        itemAmountRuleRespDto.setAmountTime(DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)itemAmountRuleEo.getAmountTime()));
        itemAmountRuleRespDto.setOrderDeductionWay(controlItemAmountConfigEo.getOrderDeductionWay());
        itemAmountRuleRespDto.setOrderDeductionScope(controlItemAmountConfigEo.getOrderDeductionScope());
        return itemAmountRuleRespDto;
    }

    @Override
    public String getTemplateExcel(String type) {
        ExcelTemplateEnum excelTemplateEnum = ExcelTemplateEnum.enumOf((Integer)Integer.parseInt(type));
        return this.excelHelper.getTemplateByExcel(excelTemplateEnum);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleAmount(ItemAmountOptVo reqVo) {
        TrControlItemAmountRecordRespDto flowInfo = this.getDefaultInfo(reqVo);
        this.handler(reqVo, flowInfo);
        this.createFlow(flowInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TrControlItemAmountRecordRespDto handleAmountBatch(ItemAmountOptVo reqVo) {
        TrControlItemAmountRecordRespDto flowInfo = this.getDefaultInfo(reqVo);
        try {
            this.handler(reqVo, flowInfo);
        }
        catch (Exception e) {
            LOGGER.error("\u4ef7\u683c\u5904\u7406:{}", (Object)e.getMessage());
            flowInfo.setFail(true);
            flowInfo.setReason(e.getMessage());
        }
        return flowInfo;
    }

    private TrControlItemAmountRecordRespDto getDefaultInfo(ItemAmountOptVo reqVo) {
        return AmountFlowHelper.getDefaultInfo(reqVo.getTypeEnum(), defaultInfo -> {
            defaultInfo.setCustomerCode(reqVo.getCustomerCode());
            defaultInfo.setCustomerName(reqVo.getCustomerName());
            defaultInfo.setTradeAmount(reqVo.getAmount());
            defaultInfo.setAmountTime(reqVo.getAmountTime());
            defaultInfo.setBillId(reqVo.getId());
            defaultInfo.setOrgId(reqVo.getOrgId());
            defaultInfo.setCreateTime(new Date());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqVo.getBusinessId()})) {
                defaultInfo.setBusinessId(reqVo.getBusinessId());
            }
            return defaultInfo;
        });
    }

    private void handler(ItemAmountOptVo reqVo, TrControlItemAmountRecordRespDto flowInfo) {
        ChangeAmountRuleVo changeAmountRuleVo = this.checkAndInit(reqVo);
        int result = this.executor(reqVo, changeAmountRuleVo, flowInfo);
        if (result < 1) {
            throw ControlExceptionCode.CHANGE_AMOUNT_FAIL.getException();
        }
    }

    @NotNull
    private ChangeAmountRuleVo checkAndInit(ItemAmountOptVo reqVo) {
        AssertUtils.notNull((Object)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)reqVo.getAmount(), (String)"amount\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)reqVo.getTypeEnum(), (String)"typeEnum\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty((String)reqVo.getCustomerCode(), (String)"customerCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty((String)reqVo.getCustomerName(), (String)"customerName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)reqVo.getAmountTime(), (String)"amountTime\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)reqVo.getOrgId(), (String)"orgId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LOGGER.info("\u8ba2\u8d27\u989d\u5ea6\u4fee\u6539\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqVo));
        ChangeAmountRuleVo changeAmountRuleVo = new ChangeAmountRuleVo();
        changeAmountRuleVo.setId(reqVo.getId());
        return changeAmountRuleVo;
    }

    private int executor(ItemAmountOptVo reqVo, ChangeAmountRuleVo changeAmountRuleVo, TrControlItemAmountRecordRespDto flowInfo) {
        int result = -1;
        switch (reqVo.getTypeEnum()) {
            case AMOUNT_MONTH: 
            case AMOUNT_ADD: {
                changeAmountRuleVo.setChangeSurplusAmount(reqVo.getAmount());
                changeAmountRuleVo.setChangeMonthAmount(reqVo.getAmount());
                changeAmountRuleVo.setChangeAllAmount(true);
                flowInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_IN.getType());
                result = this.trControlItemAmountRuleDas.addCustomerAmountOfRule(changeAmountRuleVo);
                break;
            }
            case AMOUNT_CUT: {
                this.checkAmountChangeRestrict(reqVo);
                changeAmountRuleVo.setChangeSurplusAmount(reqVo.getAmount());
                changeAmountRuleVo.setChangeMonthAmount(reqVo.getAmount());
                changeAmountRuleVo.setChangeAllAmount(true);
                flowInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_OUT.getType());
                result = this.trControlItemAmountRuleDas.reduceCustomerAmountOfRule(changeAmountRuleVo);
                break;
            }
            case AMOUNT_MONTH_SETTLE: {
                changeAmountRuleVo.setChangeSurplusAmount(reqVo.getAmount());
                changeAmountRuleVo.setChangeMonthSettleAmount(reqVo.getAmount());
                changeAmountRuleVo.setChangeAllAmount(true);
                flowInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_IN.getType());
                result = this.trControlItemAmountRuleDas.addCustomerAmountOfRule(changeAmountRuleVo);
                break;
            }
            case AMOUNT_ORDER_CUT: {
                changeAmountRuleVo.setChangeSurplusAmount(reqVo.getAmount());
                changeAmountRuleVo.setChangeUsedAmount(reqVo.getAmount());
                flowInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_OUT.getType());
                result = this.trControlItemAmountRuleDas.reduceCustomerAmountOfRule(changeAmountRuleVo);
                break;
            }
            case AMOUNT_ORDER_ROLLBACK: 
            case AMOUNT_SALESRETURN_ADD: {
                changeAmountRuleVo.setChangeSurplusAmount(reqVo.getAmount());
                changeAmountRuleVo.setChangeUsedAmount(reqVo.getAmount());
                flowInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_IN.getType());
                result = this.trControlItemAmountRuleDas.addCustomerAmountOfRule(changeAmountRuleVo);
                break;
            }
            case AMOUNT_PERSON: {
                this.checkAmountChangeRestrict(reqVo);
                result = this.importChangeCustomerAmount(reqVo, flowInfo);
                break;
            }
            default: {
                LOGGER.warn("\u4ea4\u6613\u7c7b\u578b\u4e0d\u5b58\u5728\uff1aTradeTypeEnum={},{}", (Object)reqVo.getTypeEnum().getType(), (Object)reqVo.getTypeEnum().getDesc());
            }
        }
        return result;
    }

    @Override
    public List<TrControlItemAmountRuleEo> queryTrControlItemAmountRuleListOrderByCustomerCode(List<String> amountTimeList, Integer pageNo, Integer pageSize) {
        return this.trControlItemAmountRuleMapper.queryTrControlItemAmountRuleListOrderByCustomerCode(amountTimeList, pageNo, pageSize);
    }

    @Override
    public void createFlowBatch(List<TrControlItemAmountRecordRespDto> recordRespDtos) {
        if (CollectionUtils.isEmpty(recordRespDtos)) {
            return;
        }
        Map<Long, List<TrControlItemAmountRecordRespDto>> map = recordRespDtos.stream().sorted(Comparator.comparing(BaseRespDto::getCreateTime).reversed()).collect(Collectors.groupingBy(TrControlItemAmountRecordRespDto::getBillId));
        Map<Long, BigDecimal> amountMap = ((ExtQueryChainWrapper)this.trControlItemAmountRuleDas.filter(true).in((Object)"id", map.keySet())).list().stream().peek(t -> t.setSurplusAmount(Optional.ofNullable(t.getSurplusAmount()).orElse(BigDecimal.ZERO))).collect(Collectors.toMap(BaseEo::getId, TrControlItemAmountRuleEo::getSurplusAmount));
        ArrayList flows = new ArrayList(recordRespDtos.size());
        map.forEach((k, v) -> {
            BigDecimal[] amount = new BigDecimal[]{(BigDecimal)amountMap.get(k)};
            flows.addAll(v.stream().map(record -> {
                TrControlItemAmountRecordEo itemAmountRecordEo = new TrControlItemAmountRecordEo();
                DtoHelper.dto2Eo((BaseVo)record, (BaseEo)itemAmountRecordEo);
                itemAmountRecordEo.setRemainAmount(amount[0]);
                amount[0] = amount[0].add(record.getTradeAmount());
                return itemAmountRecordEo;
            }).collect(Collectors.toList()));
        });
        this.itemAmountRecordDas.insertBatch(flows);
    }

    @Override
    public TrControlItemAmountRuleRespDto queryEffectiveRuleByCustomerCode(String customerCode) {
        TrControlItemAmountRuleRespDto trControlItemAmountRuleRespDto = null;
        TrControlItemAmountRuleEo eo = new TrControlItemAmountRuleEo();
        eo.setCustomerCode(customerCode);
        eo.setStatus(Integer.valueOf(1));
        eo = (TrControlItemAmountRuleEo)this.trControlItemAmountRuleDas.selectOne((BaseEo)eo);
        if (eo != null) {
            trControlItemAmountRuleRespDto = new TrControlItemAmountRuleRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)trControlItemAmountRuleRespDto);
        }
        return trControlItemAmountRuleRespDto;
    }

    private void checkAmountChangeRestrict(ItemAmountOptVo reqVo) {
        TrControlItemAmountRuleEo queryEo = new TrControlItemAmountRuleEo();
        queryEo.setId(reqVo.getId());
        TrControlItemAmountRuleEo itemAmountRuleEo = (TrControlItemAmountRuleEo)this.trControlItemAmountRuleDas.selectOne((BaseEo)queryEo);
        if (TradeTypeEnum.AMOUNT_CUT.equals((Object)reqVo.getTypeEnum())) {
            boolean enought;
            boolean bl = enought = itemAmountRuleEo.getSurplusAmount().subtract(reqVo.getAmount().abs()).compareTo(BigDecimal.ZERO) >= 0;
            if (!enought) {
                LOGGER.error("\u3010\u914d\u989d\u51cf\u5c11\u3011\u914d\u989d\u51cf\u5c11\u7684\u8303\u56f4\u8d85\u8fc7\u4e86\u4f59\u989d\uff0c\u914d\u989d\u51cf\u5c11\u503c\u4e3a\uff1a{}\uff0c\u5f53\u524d\u4f59\u989d\u4e3a\uff1a{}", (Object)reqVo.getAmount(), (Object)itemAmountRuleEo.getSurplusAmount());
                throw new BizException(ImportItemAmountReason.ERROR_04.getType() + "", ImportItemAmountReason.ERROR_04.getDesc());
            }
        } else if (TradeTypeEnum.AMOUNT_PERSON.equals((Object)reqVo.getTypeEnum())) {
            BigDecimal surplusAmount = itemAmountRuleEo.getSurplusAmount().add(reqVo.getAmount());
            if (reqVo.getAmount().compareTo(BigDecimal.ZERO) < 0) {
                if (surplusAmount.compareTo(BigDecimal.ZERO) < 0) {
                    LOGGER.error("\u3010\u4eba\u5de5\u5bfc\u5165\u3011\u4f59\u989d\u51cf\u5c11\u7684\u8303\u56f4\u8d85\u8fc7\u4e86\u4f59\u989d\uff0c\u51cf\u5c11\u503c\u4e3a\uff1a{}\uff0c\u5f53\u524d\u4f59\u989d\u4e3a\uff1a{}", (Object)reqVo.getAmount(), (Object)itemAmountRuleEo.getSurplusAmount());
                    throw new BizException(ImportItemAmountReason.ERROR_10.getType() + "", ImportItemAmountReason.ERROR_10.getDesc());
                }
            } else if (surplusAmount.compareTo(itemAmountRuleEo.getAllAmount()) > 0) {
                LOGGER.error("\u3010\u4eba\u5de5\u5bfc\u5165\u3011\u4f59\u989d\u589e\u52a0\u7684\u8303\u56f4\u8d85\u8fc7\u4e86\u603b\u989d\u5ea6\uff0c\u589e\u52a0\u503c\u4e3a\uff1a{}\uff0c\u5f53\u524d\u603b\u989d\u5ea6\u4e3a\uff1a{}", (Object)reqVo.getAmount(), (Object)itemAmountRuleEo.getAllAmount());
                throw new BizException(ImportItemAmountReason.ERROR_09.getType() + "", ImportItemAmountReason.ERROR_09.getDesc());
            }
        }
    }

    private void createFlow(TrControlItemAmountRecordRespDto flowInfo) {
        TrControlItemAmountRuleEo queryEo = new TrControlItemAmountRuleEo();
        queryEo.setId(flowInfo.getBillId());
        TrControlItemAmountRuleEo itemAmountRuleEo = (TrControlItemAmountRuleEo)this.trControlItemAmountRuleDas.selectOne((BaseEo)queryEo);
        TrControlItemAmountRecordEo itemAmountRecordEo = new TrControlItemAmountRecordEo();
        DtoHelper.dto2Eo((BaseVo)flowInfo, (BaseEo)itemAmountRecordEo);
        itemAmountRecordEo.setRemainAmount(itemAmountRuleEo.getSurplusAmount());
        int insert = this.itemAmountRecordDas.insert((BaseEo)itemAmountRecordEo);
        if (insert < 1) {
            LOGGER.warn("\u3010\u8ba2\u8d27\u989d\u5ea6\u7ba1\u63a7\u3011\u521b\u5efa\u6d41\u6c34\u5931\u8d25\uff0c\u6d41\u6c34\u5185\u5bb9\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)flowInfo));
            throw ControlExceptionCode.CREATE_FLOW_FAIL.getException();
        }
    }

    private int importChangeCustomerAmount(ItemAmountOptVo reqVo, TrControlItemAmountRecordRespDto flowInfo) {
        AssertUtils.notNull((Object)reqVo.getImportId(), (String)"importId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ChangeAmountRuleVo changeAmountRuleVo = new ChangeAmountRuleVo();
        changeAmountRuleVo.setId(reqVo.getId());
        changeAmountRuleVo.setChangeAllAmount(true);
        flowInfo.setImportId(reqVo.getImportId());
        int result = -1;
        if (reqVo.getAmount().compareTo(BigDecimal.ZERO) > 0) {
            flowInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_IN.getType());
            changeAmountRuleVo.setChangeSurplusAmount(reqVo.getAmount());
            result = this.trControlItemAmountRuleDas.addCustomerAmountOfRule(changeAmountRuleVo);
        } else {
            flowInfo.setOperationType(OperationTypeEnum.OPERATIONTYPEENUM_OUT.getType());
            changeAmountRuleVo.setChangeSurplusAmount(reqVo.getAmount().abs());
            result = this.trControlItemAmountRuleDas.reduceCustomerAmountOfRule(changeAmountRuleVo);
        }
        return result;
    }
}

