/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.api.enums.citic;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum CiticBankTypeEnum {
    CITIC_PERSONAL_ACCOUNT("1", "\u4e2d\u4fe1\u4e2a\u4eba\u8d26\u6237", 1),
    CITIC_ENTER_ACCOUNT("2", "\u4e2d\u4fe1\u4f01\u4e1a\u8d26\u6237", 2),
    OTHER_PERSONAL_ACCOUNT("3", "\u4ed6\u884c\u4e2a\u4eba\u8d26\u6237", 1),
    OTHER_ENTER_ACCOUNT("4", "\u4ed6\u884c\u4f01\u4e1a\u8d26\u6237", 2);

    private final String code;
    private final String name;
    private final Integer type;

    private CiticBankTypeEnum(String code, String name, Integer type) {
        this.code = code;
        this.name = name;
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getType() {
        return this.type;
    }

    public static CiticBankTypeEnum fromCode(String code) {
        for (CiticBankTypeEnum typeEnum : CiticBankTypeEnum.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum;
        }
        return null;
    }

    public static String getName(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return "";
        }
        for (CiticBankTypeEnum typeEnum : CiticBankTypeEnum.values()) {
            if (!typeEnum.getCode().equals(code)) continue;
            return typeEnum.getName();
        }
        return code;
    }

    public static Map<String, String> provideCompany() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (CiticBankTypeEnum typeEnum : CiticBankTypeEnum.values()) {
            if (typeEnum.getType() != 2) continue;
            map.put(typeEnum.getCode(), typeEnum.getName());
        }
        return map;
    }

    public static Map<String, String> providePerson() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (CiticBankTypeEnum typeEnum : CiticBankTypeEnum.values()) {
            if (typeEnum.getType() != 1) continue;
            map.put(typeEnum.getCode(), typeEnum.getName());
        }
        return map;
    }

    public static Map<String, String> provideHome() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (CiticBankTypeEnum typeEnum : CiticBankTypeEnum.values()) {
            map.put(typeEnum.getCode(), typeEnum.getName());
        }
        return map;
    }
}

