/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.tcbj.api.dto.request.CiticNotifyModifyStatusBatchReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticNotifyReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticNotifyRespDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticNotifyDealFlagEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticNotifyTransTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticNotifyTypeEnum;
import com.dtyunxi.tcbj.biz.service.ICiticNotifyService;
import com.dtyunxi.tcbj.dao.das.CiticNotifyDas;
import com.dtyunxi.tcbj.dao.eo.CiticNotifyEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.CiticNotifyData;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.CiticNotifyRequest;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.CiticResponse;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.service.ICiticPartnerService;
import com.github.pagehelper.PageInfo;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CiticNotifyServiceImpl
implements ICiticNotifyService {
    Logger log = LoggerFactory.getLogger(CiticNotifyServiceImpl.class);
    private static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    @Resource
    private CiticNotifyDas citicNotifyDas;
    @Resource
    private ICiticPartnerService citicPartnerService;

    @Override
    public String citicNotify(String xml) {
        XStream xStream = new XStream();
        xStream.alias("ROOT", CiticNotifyRequest.class);
        xStream.alias("NOTIFY_DATA", CiticNotifyData.class);
        CiticNotifyRequest reqData = (CiticNotifyRequest)xStream.fromXML(xml);
        String sigStr = reqData.getSIGN_INFO();
        boolean isSucc = this.citicPartnerService.verifySign(CiticNotifyRequest.sortSignInfo((String)xml), sigStr);
        if (!isSucc) {
            this.log.error("\u4e2d\u4fe1e\u7ba1\u5bb6\u901a\u77e5\u63a5\u53e3\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7b7e\u540d");
            throw new RuntimeException();
        }
        if (!CiticNotifyTypeEnum.RECHARGE.key.equals(reqData.getNOTIFY_TP())) {
            this.log.error("\u975e\u5165\u91d1\u52a8\u8d26\u901a\u77e5\uff0c\u65e0\u9700\u64cd\u4f5c");
            return null;
        }
        CiticNotifyEo eo = new CiticNotifyEo();
        eo.setNotifySsn(reqData.getNOTIFY_SSN());
        eo.setMchntId(reqData.getMCHNT_ID());
        eo.setNotifyTp(reqData.getNOTIFY_TP());
        eo.setTransDt(reqData.getNOTIFY_DATA().getTRANS_DT());
        eo.setTransTm(reqData.getNOTIFY_DATA().getTRANS_TM());
        eo.setTransAmt(reqData.getNOTIFY_DATA().getTRANS_AMT());
        eo.setCDFlag(reqData.getNOTIFY_DATA().getC_D_FLAG());
        eo.setPayAccno(reqData.getNOTIFY_DATA().getPAY_ACCNO());
        eo.setPayAccname(reqData.getNOTIFY_DATA().getPAY_ACCNAME());
        eo.setUserName(reqData.getNOTIFY_DATA().getUSERNAME());
        eo.setUserNo(reqData.getNOTIFY_DATA().getUSERNO());
        eo.setTransTp(reqData.getNOTIFY_DATA().getTRANS_TP());
        eo.setDigest(reqData.getNOTIFY_DATA().getDIGEST());
        eo.setRemark(reqData.getNOTIFY_DATA().getREMARK());
        if (CiticNotifyTransTypeEnum.CHANNEL_RECHARGE.key.equals(reqData.getNOTIFY_DATA().getTRANS_TP()) || CiticNotifyTransTypeEnum.TRANSFER_RECHARGE.key.equals(reqData.getNOTIFY_DATA().getTRANS_TP())) {
            eo.setDealFlag(CiticNotifyDealFlagEnum.TO_DO.key);
        } else {
            eo.setDealFlag(CiticNotifyDealFlagEnum.FINISHED.key);
        }
        this.citicNotifyDas.insert((BaseEo)eo);
        CiticResponse citicResponse = new CiticResponse();
        citicResponse.setRSP_CODE("00000");
        citicResponse.setRSP_MSG("success");
        XStream xtreamData = new XStream();
        xtreamData.alias("ROOT", CiticResponse.class);
        String restr = xtreamData.toXML((Object)citicResponse).replace("__", "_");
        restr = XML_HEAD + restr;
        return restr;
    }

    @Override
    public CiticNotifyRespDto queryById(Long id) {
        CiticNotifyEo citicNotifyEo = (CiticNotifyEo)this.citicNotifyDas.selectByPrimaryKey(id);
        CiticNotifyRespDto citicNotifyRespDto = new CiticNotifyRespDto();
        DtoHelper.eo2Dto((BaseEo)citicNotifyEo, (BaseVo)citicNotifyRespDto);
        return citicNotifyRespDto;
    }

    @Override
    public PageInfo<CiticNotifyRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CiticNotifyReqDto citicNotifyReqDto = (CiticNotifyReqDto)JSON.parseObject((String)filter, CiticNotifyReqDto.class);
        CiticNotifyEo citicNotifyEo = new CiticNotifyEo();
        DtoHelper.dto2Eo((BaseVo)citicNotifyReqDto, (BaseEo)citicNotifyEo);
        PageInfo eoPageInfo = this.citicNotifyDas.selectPage((BaseEo)citicNotifyEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CiticNotifyRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyStatusBatch(CiticNotifyModifyStatusBatchReqDto dto) {
        for (String ssn : dto.getNotifySsnList()) {
            CiticNotifyEo query = new CiticNotifyEo();
            query.setNotifySsn(ssn);
            CiticNotifyEo record = (CiticNotifyEo)this.citicNotifyDas.selectOne((BaseEo)query);
            if (record == null) continue;
            CiticNotifyEo update = new CiticNotifyEo();
            update.setId(record.getId());
            update.setDealFlag(dto.getDealFlag());
            this.citicNotifyDas.updateSelective((BaseEo)update);
        }
    }
}

