/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountPayReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountRefundReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransDetailQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransDetailUnverifiedQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransVerifyReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountWithdrawReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticFileDownloadReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticFileUploadReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticReturnResultBatchQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticSetDefaultWithdrawCardReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticTransStateQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticUserAddReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticUserBindCardReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticUserCancelReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticUserModifyReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticWithResultBatchQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticWithReturnCompleteBatchReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountPayResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountRefundResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountTransDetailQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountTransDetailUnverifiedQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountWithdrawResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticBankCodesQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticFileDownloadResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticFileDownloadResultQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticFileStateQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticFileUploadResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticReturnResultQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticTransStateQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticUserAddResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticUserBalanceQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticUserCancelResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticWithResultQueryResDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticFileTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticNotifyDealFlagEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticReturnResultEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticUserOperateTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticUserTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticWithResultEnum;
import com.dtyunxi.tcbj.api.exception.PaymentExceptionCode;
import com.dtyunxi.tcbj.biz.config.PaymentProperties;
import com.dtyunxi.tcbj.biz.service.ICiticService;
import com.dtyunxi.tcbj.biz.service.IFileDownloadLogService;
import com.dtyunxi.tcbj.dao.das.AccountPayDas;
import com.dtyunxi.tcbj.dao.das.AccountRefundDas;
import com.dtyunxi.tcbj.dao.das.AccountTransDetailDas;
import com.dtyunxi.tcbj.dao.das.BankCodeDas;
import com.dtyunxi.tcbj.dao.das.WithApplyDas;
import com.dtyunxi.tcbj.dao.das.WithResultDas;
import com.dtyunxi.tcbj.dao.das.WithReturnDas;
import com.dtyunxi.tcbj.dao.eo.AccountPayEo;
import com.dtyunxi.tcbj.dao.eo.AccountRefundEo;
import com.dtyunxi.tcbj.dao.eo.AccountTransDetailEo;
import com.dtyunxi.tcbj.dao.eo.BankCodeEo;
import com.dtyunxi.tcbj.dao.eo.FileDownloadLogEo;
import com.dtyunxi.tcbj.dao.eo.WithApplyEo;
import com.dtyunxi.tcbj.dao.eo.WithResultEo;
import com.dtyunxi.tcbj.dao.eo.WithReturnEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.config.CiticProperties;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000001Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000003Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000007Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000008Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000009Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000010Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000012Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000014Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000024Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000025Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000029Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000033Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000034Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000038Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000001Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000003Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000007Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000008Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000009Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000010Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000012Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000014Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000024Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000025Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000029Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000029ResponseData;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000033Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000034Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000038Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.service.ICiticPartnerService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CiticServiceImpl
implements ICiticService {
    Logger log = LoggerFactory.getLogger(CiticServiceImpl.class);
    @Resource
    private ICiticPartnerService citicPartnerService;
    @Resource
    private PaymentProperties paymentProperties;
    @Resource
    private CiticProperties citicProperties;
    @Resource
    private BankCodeDas bankCodeDas;
    @Resource
    private WithResultDas withResultDas;
    @Resource
    private WithReturnDas withReturnDas;
    @Resource
    private WithApplyDas withApplyDas;
    @Resource
    private AccountPayDas accountPayDas;
    @Resource
    private AccountRefundDas accountRefundDas;
    @Resource
    private AccountTransDetailDas accountTransDetailDas;
    @Resource
    private IFileDownloadLogService fileDownloadLogService;

    @Override
    public CiticUserAddResDto addUser(CiticUserAddReqDto dto) {
        this.verifyAddUserParams(dto);
        T21000001Request request = new T21000001Request();
        request.setMCHNT_USER_ID(dto.getMchntUserId());
        request.setUSER_TYPE(dto.getUserType());
        request.setUSER_NM(dto.getUserNm());
        request.setUSER_ROLE(dto.getUserRole());
        request.setUSER_ID_TYPE(dto.getUserIdType());
        request.setUSER_ID_NO(dto.getUserIdNo());
        request.setUSER_PHONE(dto.getUserPhone());
        request.setCORP_NM(dto.getCorpNm());
        request.setCORP_ID_NO(dto.getCorpIdNo());
        T21000001Response response = this.citicPartnerService.T21000001(request);
        CiticUserAddResDto resDto = new CiticUserAddResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setUserId(response.getUSER_ID());
        return resDto;
    }

    private void verifyAddUserParams(CiticUserAddReqDto dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getUserIdType()) && StringUtils.isBlank((CharSequence)dto.getUserIdNo())) {
            throw new BizException(PaymentExceptionCode.CITIC_CARD_TYPE_REQUIRE_CARD_NO.getCode(), PaymentExceptionCode.CITIC_CARD_TYPE_REQUIRE_CARD_NO.getMsg());
        }
        if (CiticUserTypeEnum.CORP.key.equals(dto.getUserType()) && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getUserIdType(), dto.getUserIdNo(), dto.getCorpNm(), dto.getCorpIdNo()})) {
            throw new BizException(PaymentExceptionCode.CITIC_CORP_REG_INVALID.getCode(), PaymentExceptionCode.CITIC_CORP_REG_INVALID.getMsg());
        }
        if (CiticUserTypeEnum.PERSONAL.key.equals(dto.getUserType()) && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getUserPhone()})) {
            throw new BizException(PaymentExceptionCode.CITIC_PERSONAL_REG_INVALID.getCode(), PaymentExceptionCode.CITIC_PERSONAL_REG_INVALID.getMsg());
        }
        if (CiticUserTypeEnum.INDIVIDUAL_BUSINESS.key.equals(dto.getUserType()) && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dto.getCorpNm(), dto.getCorpIdNo()})) {
            throw new BizException(PaymentExceptionCode.CITIC_INDIVIDUAL_BUSINESS_REG_INVALID.getCode(), PaymentExceptionCode.CITIC_INDIVIDUAL_BUSINESS_REG_INVALID.getMsg());
        }
    }

    @Override
    public CiticResDto modifyUser(CiticUserModifyReqDto dto) {
        this.verifyModifyUserParams(dto);
        T21000003Request request = new T21000003Request();
        request.setUSER_ID(dto.getUserId());
        request.setUSER_NM(dto.getUserNm());
        request.setUSER_ROLE(dto.getUserRole());
        request.setUSER_CARD_TP(dto.getUserCardTp());
        request.setUSER_CARD_NO(dto.getUserCardNo());
        request.setUSER_PHONE(dto.getUserPhone());
        request.setCORP_NM(dto.getCorpNm());
        request.setCORP_ID_TYPE(dto.getCorpIdType());
        T21000003Response response = this.citicPartnerService.T21000003(request);
        CiticResDto resDto = new CiticResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        return resDto;
    }

    private void verifyModifyUserParams(CiticUserModifyReqDto dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getUserCardTp()) && StringUtils.isBlank((CharSequence)dto.getUserCardNo())) {
            throw new BizException(PaymentExceptionCode.CITIC_CARD_TYPE_REQUIRE_CARD_NO.getCode(), PaymentExceptionCode.CITIC_CARD_TYPE_REQUIRE_CARD_NO.getMsg());
        }
    }

    @Override
    public CiticResDto userBindCard(CiticUserBindCardReqDto dto) {
        T21000024Request request = new T21000024Request();
        request.setUSER_ID(dto.getUserId());
        request.setOP_TYPE(dto.getOpType());
        request.setPAN_NUM(dto.getPanNum());
        request.setACCT_NM(dto.getAcctNm());
        request.setPAN(dto.getPan());
        request.setUSER_ID_TYPE(dto.getUserIdType());
        request.setBANK_CARD_NO(dto.getBankCardNo());
        request.setACCT_TYPE(dto.getAcctType());
        request.setBANK_PHONE(dto.getBankPhone());
        request.setAUTH_PROTOCOL_VERSION(dto.getAuthProtocolVersion());
        request.setAUTH_PROTOCOL_NO(dto.getAuthProtocolNo());
        T21000024Response response = this.citicPartnerService.T21000024(request);
        CiticResDto resDto = new CiticResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        return resDto;
    }

    @Override
    public CiticUserCancelResDto userCancel(CiticUserCancelReqDto dto) {
        T21000038Request request = new T21000038Request();
        request.setUSER_ID(dto.getUserId());
        request.setUSER_NM(dto.getUserNm());
        request.setOPERATE_TYPE(CiticUserOperateTypeEnum.CANCEL.key);
        T21000038Response response = this.citicPartnerService.T21000038(request);
        CiticUserCancelResDto resDto = new CiticUserCancelResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setMessage(response.getMESSAGE());
        return resDto;
    }

    @Override
    public CiticResDto setWithdrawCard(CiticSetDefaultWithdrawCardReqDto dto) {
        T21000025Request request = new T21000025Request();
        request.setUSER_ID(dto.getUserId());
        request.setSETTLE_ACCT(dto.getSettleAcct());
        request.setSETTLE_ACCT_NM(dto.getSettleAcctNm());
        T21000025Response response = this.citicPartnerService.T21000025(request);
        CiticResDto resDto = new CiticResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        return resDto;
    }

    @Override
    public CiticUserBalanceQueryResDto userBalanceQuery(String userId) {
        T21000009Request request = new T21000009Request();
        request.setUSER_ID(userId);
        T21000009Response response = this.citicPartnerService.T21000009(request);
        CiticUserBalanceQueryResDto resDto = new CiticUserBalanceQueryResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        if (StringUtils.isNotBlank((CharSequence)response.getAMOUNT())) {
            resDto.setAmount(new BigDecimal(response.getAMOUNT()));
        }
        return resDto;
    }

    @Override
    public CiticTransStateQueryResDto transStateQuery(CiticTransStateQueryReqDto dto) {
        T21000010Request request = new T21000010Request();
        request.setUSER_ID(dto.getUserId());
        request.setORI_USER_SSN(dto.getOriUserSsn());
        request.setORI_REQ_SSN(dto.getOriReqSsn());
        request.setUSER_TRANS_DT(dto.getUserTransDt());
        request.setTRANS_TYPE(dto.getTransType());
        request.setBUSS_ID(dto.getBussId());
        request.setBUSS_SUB_ID(dto.getBussSubId());
        T21000010Response response = this.citicPartnerService.T21000010(request);
        CiticTransStateQueryResDto resDto = new CiticTransStateQueryResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setState(response.getSTATE());
        resDto.setUserSsn(response.getUSER_SSN());
        resDto.setResultCode(response.getRESULT_CODE());
        resDto.setResultMsg(response.getRESULT_MSG());
        return resDto;
    }

    @Override
    public CiticAccountPayResDto accountPay(CiticAccountPayReqDto dto) {
        T21000033Request request = new T21000033Request();
        request.setUSER_D_ID(dto.getUserDId());
        request.setUSER_D_NM(dto.getUserDNm());
        request.setUSER_C_ID(dto.getUserCId());
        request.setUSER_C_NM(dto.getUserCNm());
        request.setUSER_C_AMT(dto.getUserCAmt());
        request.setTRANS_AMT(dto.getTransAmt());
        request.setP_SELF_FLAG(dto.getpSelfFlag());
        request.setP_SELF_AMT(dto.getpSelfAmt());
        request.setBUSS_ID(dto.getBussId());
        request.setBUSS_SUB_ID(dto.getBussSubId());
        request.setTRANS_DT(dto.getTransDt());
        request.setTRANS_TM(dto.getTransTm());
        request.setFUND_TP(dto.getFundTp());
        request.setMEMO(dto.getMemo());
        T21000033Response response = this.citicPartnerService.T21000033(request);
        CiticAccountPayResDto resDto = new CiticAccountPayResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setReqSsn(response.getREQ_SSN());
        resDto.setUserTransDt(response.getUSER_TRANS_DT());
        resDto.setUserTransTm(response.getUSER_TRANS_TM());
        AccountPayEo eo = new AccountPayEo();
        eo.setUserDId(dto.getUserDId());
        eo.setUserDNm(dto.getUserDNm());
        eo.setUserCId(dto.getUserCId());
        eo.setUserCNm(dto.getUserCNm());
        eo.setUserCAmt(dto.getUserCAmt());
        eo.setTransAmt(dto.getTransAmt());
        eo.setpSelfFlag(dto.getpSelfFlag());
        eo.setpSelfAmt(dto.getpSelfAmt());
        eo.setBussId(dto.getBussId());
        eo.setBussSubId(dto.getBussSubId());
        eo.setTransDt(dto.getTransDt());
        eo.setTransTm(dto.getTransTm());
        eo.setFundTp(dto.getFundTp());
        eo.setMemo(dto.getMemo());
        eo.setRspCode(response.getRSP_CODE());
        eo.setRspMsg(response.getRSP_MSG());
        eo.setReqSsn(response.getREQ_SSN());
        eo.setUserSsn(response.getUSER_SSN());
        eo.setUserTransDt(response.getUSER_TRANS_DT());
        eo.setUserTransTm(response.getUSER_TRANS_TM());
        this.accountPayDas.insert((BaseEo)eo);
        return resDto;
    }

    @Override
    public CiticAccountRefundResDto accountRefund(CiticAccountRefundReqDto dto) {
        T21000034Request request = new T21000034Request();
        request.setORI_USER_D_ID(dto.getOriUserDId());
        request.setORI_USER_D_NM(dto.getOriUserDNm());
        request.setORI_USER_C_ID(dto.getOriUserCId());
        request.setORI_USER_C_NM(dto.getOriUserCNm());
        request.setORI_USER_C_AMT(dto.getOriUserCAmt());
        request.setTRANS_AMT(dto.getTransAmt());
        request.setP_SELF_FLAG(dto.getpSelfFlag());
        request.setP_DEAL_AMT(dto.getpDealAmt());
        request.setREFUND_BUSS_ID(dto.getRefundBussId());
        request.setREFUND_BUSS_SUB_ID(dto.getRefundBussSubId());
        request.setORI_BUSS_ID(dto.getOriBussId());
        request.setORI_BUSS_SUB_ID(dto.getOriBussSubId());
        request.setORI_USER_SSN(dto.getOriUserSsn());
        request.setORI_USER_TRANS_DT(dto.getOriUserTransDt());
        request.setTRANS_DT(dto.getTransDt());
        request.setTRANS_TM(dto.getTransTm());
        request.setFUND_TP(dto.getFundTp());
        request.setMEMO(dto.getMemo());
        T21000034Response response = this.citicPartnerService.T21000034(request);
        CiticAccountRefundResDto resDto = new CiticAccountRefundResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setReqSsn(response.getREQ_SSN());
        resDto.setUserTransDt(response.getUSER_TRANS_DT());
        resDto.setUserTransTm(response.getUSER_TRANS_TM());
        AccountRefundEo eo = new AccountRefundEo();
        eo.setOriUserDId(dto.getOriUserDId());
        eo.setOriUserDNm(dto.getOriUserDNm());
        eo.setOriUserCId(dto.getOriUserCId());
        eo.setOriUserCNm(dto.getOriUserCNm());
        eo.setOriUserCAmt(dto.getOriUserCAmt());
        eo.setTransAmt(dto.getTransAmt());
        eo.setpSelfFlag(dto.getpSelfFlag());
        eo.setpDealAmt(dto.getpDealAmt());
        eo.setRefundBussId(dto.getRefundBussId());
        eo.setRefundBussSubId(dto.getRefundBussSubId());
        eo.setOriBussId(dto.getOriBussId());
        eo.setOriBussSubId(dto.getOriBussSubId());
        eo.setOriUserSsn(dto.getOriUserSsn());
        eo.setOriUserTransDt(dto.getOriUserTransDt());
        eo.setTransDt(dto.getTransDt());
        eo.setTransTm(dto.getTransTm());
        eo.setFundTp(dto.getFundTp());
        eo.setMemo(dto.getMemo());
        eo.setRspCode(response.getRSP_CODE());
        eo.setRspMsg(response.getRSP_MSG());
        eo.setReqSsn(response.getREQ_SSN());
        eo.setUserSsn(response.getUSER_SSN());
        eo.setUserTransDt(response.getUSER_TRANS_DT());
        eo.setUserTransTm(response.getUSER_TRANS_TM());
        this.accountRefundDas.insert((BaseEo)eo);
        return resDto;
    }

    @Override
    public CiticFileDownloadResDto fileDownload(CiticFileDownloadReqDto dto) {
        T21000007Request request = new T21000007Request();
        request.setFILE_NAME(dto.getFileName());
        request.setFILE_TYPE(dto.getFileType());
        request.setSETTLE_DT(dto.getSettleDt());
        T21000007Response response = this.citicPartnerService.T21000007(request);
        CiticFileDownloadResDto resDto = new CiticFileDownloadResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setReqSsn(response.getREQ_SSN());
        resDto.setFileContent(response.getFILE_CONTENT());
        return resDto;
    }

    @Override
    public CiticFileDownloadResultQueryResDto fileDownloadResultQuery(String fileType, String settleDt) {
        CiticFileDownloadResultQueryResDto result = new CiticFileDownloadResultQueryResDto();
        FileDownloadLogEo downloadResult = this.fileDownloadLogService.queryFileDownloadLog(fileType, settleDt);
        result.setDownloadSuccess(Boolean.valueOf(false));
        if (downloadResult != null && "00000".equals(downloadResult.getResultCode())) {
            result.setDownloadSuccess(Boolean.valueOf(true));
        }
        return result;
    }

    @Override
    public CiticFileUploadResDto fileUpload(CiticFileUploadReqDto dto) {
        T21000008Request request = new T21000008Request();
        request.setFILE_COUNT(dto.getFileCount());
        request.setFILE_TYPE(dto.getFileType());
        request.setFILE_NAME(dto.getFileName());
        request.setFILE_CONTENT(dto.getFileContent());
        request.setTRANS_TYPE("MSG");
        T21000008Response response = this.citicPartnerService.T21000008(request);
        CiticFileUploadResDto resDto = new CiticFileUploadResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setReqSsn(response.getREQ_SSN());
        return resDto;
    }

    @Override
    public CiticFileStateQueryResDto fileStateQuery(String fileName) {
        T21000012Request request = new T21000012Request();
        request.setFILE_NAME(fileName);
        T21000012Response response = this.citicPartnerService.T21000012(request);
        CiticFileStateQueryResDto resDto = new CiticFileStateQueryResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setFileSt(response.getFILE_ST());
        return resDto;
    }

    @Override
    public List<CiticBankCodesQueryResDto> bankCodesQuery(String bankCode, String bankName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)bankCode)) {
            queryWrapper.like(BankCodeEo::getBankCode, (Object)bankCode);
        }
        if (StringUtils.isNotBlank((CharSequence)bankName)) {
            queryWrapper.like(BankCodeEo::getBankName, (Object)bankName);
        }
        queryWrapper.orderByAsc(BankCodeEo::getId);
        queryWrapper.last("limit 30");
        List bankCodeList = this.bankCodeDas.list((Wrapper)queryWrapper);
        ArrayList<CiticBankCodesQueryResDto> resDtoList = new ArrayList<CiticBankCodesQueryResDto>();
        if (!bankCodeList.isEmpty()) {
            for (BankCodeEo bankCodeEo : bankCodeList) {
                CiticBankCodesQueryResDto resDto = new CiticBankCodesQueryResDto();
                resDto.setBankCode(bankCodeEo.getBankCode());
                resDto.setBankName(bankCodeEo.getBankName());
                resDtoList.add(resDto);
            }
        }
        return resDtoList;
    }

    @Override
    public CiticBankCodesQueryResDto queryByBankCode(String bankCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BankCodeEo::getBankCode, (Object)bankCode);
        BankCodeEo eo = (BankCodeEo)this.bankCodeDas.getOne((Wrapper)queryWrapper);
        CiticBankCodesQueryResDto resDto = null;
        if (eo != null) {
            resDto = new CiticBankCodesQueryResDto();
            resDto.setBankCode(eo.getBankCode());
            resDto.setBankName(eo.getBankName());
        }
        return resDto;
    }

    @Override
    public CiticAccountWithdrawResDto accountWithdraw(CiticAccountWithdrawReqDto dto) {
        T21000014Request request = new T21000014Request();
        request.setUSER_ID(dto.getUserId());
        request.setWITH_TYPE(dto.getWithType());
        request.setBUSS_ID(dto.getBussId());
        request.setTRANS_DT(dto.getTransDt());
        request.setTRANS_TM(dto.getTransTm());
        request.setFEE_TYPE(dto.getFeeType());
        request.setWITH_AMT(dto.getWithAmt().toString());
        request.setMEMO(dto.getMemo());
        request.setWITH_ACCOUNT(dto.getWithAccount());
        request.setWITH_ACCNAME(dto.getWithAccname());
        T21000014Response response = this.citicPartnerService.T21000014(request);
        CiticAccountWithdrawResDto resDto = new CiticAccountWithdrawResDto();
        resDto.setRspCode(response.getRSP_CODE());
        resDto.setRspMsg(response.getRSP_MSG());
        resDto.setReqSsn(response.getREQ_SSN());
        resDto.setUserTransDt(response.getUSER_TRANS_DT());
        resDto.setUserTransTm(response.getUSER_TRANS_TM());
        resDto.setWithChannel(response.getWITH_CHANNEL());
        WithApplyEo eo = new WithApplyEo();
        eo.setUserId(dto.getUserId());
        eo.setWith_type(dto.getWithType());
        eo.setBussId(dto.getBussId());
        eo.setTransDt(dto.getTransDt());
        eo.setTransTm(dto.getTransTm());
        eo.setFeeType(dto.getFeeType());
        eo.setWithAmt(dto.getWithAmt().toString());
        eo.setMemo(dto.getMemo());
        eo.setWithAccount(dto.getWithAccount());
        eo.setWithAccname(dto.getWithAccname());
        eo.setReqSsn(response.getREQ_SSN());
        eo.setRspCode(response.getRSP_CODE());
        eo.setRspMsg(response.getRSP_MSG());
        eo.setWithChannel(response.getWITH_CHANNEL());
        this.withApplyDas.insert((BaseEo)eo);
        return resDto;
    }

    @Override
    public CiticWithResultQueryResDto withResultQuery(String bussId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WithResultEo::getBussId, (Object)bussId);
        WithResultEo result = (WithResultEo)this.withResultDas.getOne((Wrapper)queryWrapper);
        CiticWithResultQueryResDto resDto = new CiticWithResultQueryResDto();
        resDto.setBussId(bussId);
        if (result == null) {
            resDto.setWithResult(CiticWithResultEnum.QUERY_PROCESSING.key);
            resDto.setWithDesc(CiticWithResultEnum.QUERY_PROCESSING.label);
            return resDto;
        }
        resDto.setSerialNo(result.getSerialNo());
        resDto.setWithResult(result.getWithResult());
        resDto.setWithDesc(result.getWithDesc());
        BigDecimal withAmt = new BigDecimal(result.getWithAmt()).divide(new BigDecimal(100), 2, 4);
        resDto.setWithAmt(withAmt);
        BigDecimal withFee = new BigDecimal(result.getWithFee()).divide(new BigDecimal(100), 2, 4);
        resDto.setWithFee(withFee);
        BigDecimal advanceAmt = new BigDecimal(result.getAdvanceAmt()).divide(new BigDecimal(100), 2, 4);
        resDto.setAdvanceAmt(advanceAmt);
        resDto.setWithAccountType(result.getWithAccountType());
        resDto.setWithFeeType(result.getWithFeeType());
        return resDto;
    }

    @Override
    public List<CiticWithResultQueryResDto> withResultBatchQuery(CiticWithResultBatchQueryReqDto dto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(WithResultEo::getBussId, (Collection)dto.getBussIds());
        List eoList = this.withResultDas.list((Wrapper)queryWrapper);
        ArrayList<CiticWithResultQueryResDto> resDtoList = new ArrayList<CiticWithResultQueryResDto>();
        if (!eoList.isEmpty()) {
            for (WithResultEo result : eoList) {
                CiticWithResultQueryResDto resDto = new CiticWithResultQueryResDto();
                resDto.setBussId(result.getBussId());
                resDto.setSerialNo(result.getSerialNo());
                resDto.setWithResult(result.getWithResult());
                resDto.setWithDesc(result.getWithDesc());
                BigDecimal withAmt = new BigDecimal(result.getWithAmt()).divide(new BigDecimal(100), 2, 4);
                resDto.setWithAmt(withAmt);
                BigDecimal withFee = new BigDecimal(result.getWithFee()).divide(new BigDecimal(100), 2, 4);
                resDto.setWithFee(withFee);
                BigDecimal advanceAmt = new BigDecimal(result.getAdvanceAmt()).divide(new BigDecimal(100), 2, 4);
                resDto.setAdvanceAmt(advanceAmt);
                resDto.setWithAccountType(result.getWithAccountType());
                resDto.setWithFeeType(result.getWithFeeType());
                resDtoList.add(resDto);
            }
        }
        return resDtoList;
    }

    @Override
    public CiticReturnResultQueryResDto returnResultQuery(String bussId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WithReturnEo::getBussId, (Object)bussId);
        WithReturnEo result = (WithReturnEo)this.withReturnDas.getOne((Wrapper)queryWrapper);
        CiticReturnResultQueryResDto resDto = new CiticReturnResultQueryResDto();
        if (result == null) {
            resDto.setReturnFlag(CiticReturnResultEnum.NOT_RETURNED.key);
            return resDto;
        }
        resDto.setReturnFlag(CiticReturnResultEnum.RETURNED.key);
        resDto.setUserId(result.getUserId());
        resDto.setReturnDt(result.getReturnDt());
        resDto.setReturnTm(result.getReturnTm());
        BigDecimal returnAmt = new BigDecimal(result.getReturnAmt()).divide(new BigDecimal(100), 2, 4);
        resDto.setReturnAmt(returnAmt);
        resDto.setReturnReason(result.getReturnReason());
        resDto.setBussId(result.getBussId());
        resDto.setWithDt(result.getWithDt());
        BigDecimal withAmt = new BigDecimal(result.getWithAmt()).divide(new BigDecimal(100), 2, 4);
        resDto.setWithAmt(withAmt);
        return resDto;
    }

    @Override
    public List<CiticReturnResultQueryResDto> returnResultBatchQuery(CiticReturnResultBatchQueryReqDto dto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(WithReturnEo::getBussId, (Collection)dto.getBussIds());
        List eoList = this.withReturnDas.list((Wrapper)queryWrapper);
        ArrayList<CiticReturnResultQueryResDto> resDtoList = new ArrayList<CiticReturnResultQueryResDto>();
        if (!eoList.isEmpty()) {
            for (WithReturnEo result : eoList) {
                CiticReturnResultQueryResDto resDto = new CiticReturnResultQueryResDto();
                resDto.setReturnFlag(CiticReturnResultEnum.RETURNED.key);
                resDto.setUserId(result.getUserId());
                resDto.setReturnDt(result.getReturnDt());
                resDto.setReturnTm(result.getReturnTm());
                BigDecimal returnAmt = new BigDecimal(result.getReturnAmt()).divide(new BigDecimal(100), 2, 4);
                resDto.setReturnAmt(returnAmt);
                resDto.setReturnReason(result.getReturnReason());
                resDto.setBussId(result.getBussId());
                resDto.setWithDt(result.getWithDt());
                BigDecimal withAmt = new BigDecimal(result.getWithAmt()).divide(new BigDecimal(100), 2, 4);
                resDto.setWithAmt(withAmt);
                resDtoList.add(resDto);
            }
        }
        return resDtoList;
    }

    @Override
    public List<CiticReturnResultQueryResDto> withReturnTodoListQuery(Integer size) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WithReturnEo::getDealFlag, (Object)CiticNotifyDealFlagEnum.TO_DO.key);
        queryWrapper.orderByAsc(WithReturnEo::getCreateTime);
        queryWrapper.last("limit " + size);
        List eoList = this.withReturnDas.list((Wrapper)queryWrapper);
        ArrayList<CiticReturnResultQueryResDto> resDtoList = new ArrayList<CiticReturnResultQueryResDto>();
        if (!eoList.isEmpty()) {
            for (WithReturnEo result : eoList) {
                CiticReturnResultQueryResDto resDto = new CiticReturnResultQueryResDto();
                resDto.setReturnFlag(CiticReturnResultEnum.RETURNED.key);
                resDto.setUserId(result.getUserId());
                resDto.setReturnDt(result.getReturnDt());
                resDto.setReturnTm(result.getReturnTm());
                BigDecimal returnAmt = new BigDecimal(result.getReturnAmt()).divide(new BigDecimal(100), 2, 4);
                resDto.setReturnAmt(returnAmt);
                resDto.setReturnReason(result.getReturnReason());
                resDto.setBussId(result.getBussId());
                resDto.setWithDt(result.getWithDt());
                BigDecimal withAmt = new BigDecimal(result.getWithAmt()).divide(new BigDecimal(100), 2, 4);
                resDto.setWithAmt(withAmt);
                resDtoList.add(resDto);
            }
        }
        return resDtoList;
    }

    @Override
    public List<CiticAccountTransDetailQueryResDto> accountTransDetailQuery(CiticAccountTransDetailQueryReqDto dto) {
        T21000029Request request = new T21000029Request();
        request.setUSER_ID(dto.getUserId());
        request.setTRANS_DATE(dto.getTransDate());
        request.setTRANS_TYPE(dto.getTransType());
        request.setPAGE(dto.getPage() + "");
        T21000029Response response = this.citicPartnerService.T21000029(request);
        if (!"00000".equals(response.getRSP_CODE())) {
            throw new BizException(response.getRSP_CODE(), response.getRSP_MSG());
        }
        ArrayList<CiticAccountTransDetailQueryResDto> resultList = new ArrayList<CiticAccountTransDetailQueryResDto>();
        if (!response.getLIST().isEmpty()) {
            for (T21000029ResponseData data : response.getLIST()) {
                CiticAccountTransDetailQueryResDto result = new CiticAccountTransDetailQueryResDto();
                result.setUserName(data.getUSER_NAME());
                result.setTransDt(data.getTRANS_DT());
                result.setTransTm(data.getTRANS_TM());
                result.setTransType(data.getTRANS_TYPE());
                result.setReqJrn(data.getREQ_JRN());
                result.setMchntOrderId(data.getMCHNT_ORDER_ID());
                result.setMchntOrderSubId(data.getMCHNT_ORDER_SUB_ID());
                result.setRegisterSsn(data.getREGISTER_SSN());
                result.setTransAmt(data.getTRANS_AMT());
                result.setcDFlag(data.getC_D_FLAG());
                result.setCurAmt(data.getCUR_AMT());
                result.setGoac(data.getGOAC());
                result.setOanm(data.getOANM());
                result.setDigest(data.getDIGEST());
                resultList.add(result);
            }
        }
        return resultList;
    }

    @Override
    public List<CiticAccountTransDetailUnverifiedQueryResDto> accountTransDetailUnverifiedQuery(CiticAccountTransDetailUnverifiedQueryReqDto dto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)dto.getUserId())) {
            queryWrapper.eq(AccountTransDetailEo::getUserId, (Object)dto.getUserId());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTransDate())) {
            queryWrapper.eq(AccountTransDetailEo::getTransDt, (Object)dto.getTransDate());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTransType())) {
            queryWrapper.eq(AccountTransDetailEo::getTransType, (Object)dto.getTransType());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getVerifyFlag())) {
            queryWrapper.eq(AccountTransDetailEo::getVerifyFlag, (Object)dto.getVerifyFlag());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getBussId())) {
            queryWrapper.eq(AccountTransDetailEo::getBussId, (Object)dto.getBussId());
        }
        queryWrapper.orderByAsc(AccountTransDetailEo::getId);
        queryWrapper.last("limit " + dto.getSize());
        List transList = this.accountTransDetailDas.list((Wrapper)queryWrapper);
        ArrayList<CiticAccountTransDetailUnverifiedQueryResDto> resultList = new ArrayList<CiticAccountTransDetailUnverifiedQueryResDto>();
        if (!transList.isEmpty()) {
            for (AccountTransDetailEo data : transList) {
                CiticAccountTransDetailUnverifiedQueryResDto result = new CiticAccountTransDetailUnverifiedQueryResDto();
                result.setId(data.getId());
                result.setUserId(data.getUserId());
                result.setUserName(data.getUserName());
                result.setTransDt(data.getTransDt());
                result.setTransTm(data.getTransTm());
                result.setTransType(data.getTransType());
                result.setUserSsn(data.getUserSsn());
                result.setBussId(data.getBussId());
                result.setBussSubId(data.getBussSubId());
                String amountStr = data.getTransAmt();
                BigDecimal transAmt = new BigDecimal(amountStr).divide(new BigDecimal(100), 2, 4);
                result.setTransAmt(transAmt.toString());
                result.setcDFlag(data.getcDFlag());
                String curAmtStr = data.getCurAmt();
                BigDecimal curAmt = new BigDecimal(curAmtStr).divide(new BigDecimal(100), 2, 4);
                result.setCurAmt(curAmt.toString());
                result.setGoac(data.getGoac());
                result.setOanm(data.getOanm());
                result.setDigest(data.getDigest());
                resultList.add(result);
            }
        }
        return resultList;
    }

    @Override
    public void withReturnCompleteBatch(CiticWithReturnCompleteBatchReqDto dto) {
        for (String bussId : dto.getBussIds()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.withReturnDas.lambdaUpdate().eq(WithReturnEo::getBussId, (Object)bussId)).set(WithReturnEo::getDealFlag, (Object)CiticNotifyDealFlagEnum.FINISHED.key)).update();
        }
    }

    @Override
    public void accountTransVerify(CiticAccountTransVerifyReqDto dto) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.accountTransDetailDas.lambdaUpdate().eq(AccountTransDetailEo::getId, (Object)dto.getId())).set(AccountTransDetailEo::getVerifyFlag, (Object)dto.getVerifyFlag())).update();
    }

    @Override
    public void generateBankCode(String date) {
        String fullUnzipFilePath;
        File unzipFile;
        File downloadFile;
        T21000007Request request = new T21000007Request();
        String fileName = CiticFileTypeEnum.BANK_CODE.key + date + "01";
        String downloadFileName = fileName + ".zip";
        request.setFILE_NAME(downloadFileName);
        request.setFILE_TYPE(CiticFileTypeEnum.BANK_CODE.key);
        request.setSETTLE_DT(date);
        String filePath = this.paymentProperties.getFileRootPath() + File.separator + CiticFileTypeEnum.BANK_CODE.key + File.separator + date;
        String fullDownloadFilePath = filePath + File.separator + downloadFileName;
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if (!(downloadFile = new File(fullDownloadFilePath)).exists()) {
            this.log.info("\u6267\u884ce\u7ba1\u5bb6\u8054\u884c\u53f7\u6587\u4ef6\u4e0b\u8f7d");
            T21000007Response response = this.citicPartnerService.T21000007(request);
            this.fileDownloadLogService.addFileLog(request, response);
            if (!"00000".equals(response.getRSP_CODE())) {
                this.log.error("e\u7ba1\u5bb6\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
                return;
            }
            if (StringUtils.isBlank((CharSequence)response.getFILE_CONTENT())) {
                this.log.error("e\u7ba1\u5bb6\u8054\u884c\u53f7\u6587\u4ef6\u6682\u672a\u751f\u6210,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
                return;
            }
            Utils.decoderBase64File((String)response.getFILE_CONTENT(), (String)fullDownloadFilePath);
        }
        if (!(unzipFile = new File(fullUnzipFilePath = filePath + File.separator + fileName)).exists()) {
            this.log.info("\u6267\u884ce\u7ba1\u5bb6\u8054\u884c\u53f7\u6587\u4ef6\u89e3\u538b");
            Utils.unzip((String)fullDownloadFilePath, (String)filePath);
        }
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(unzipFile), "GBK");
             BufferedReader bufferRead = new BufferedReader(read);){
            String lineContent;
            while ((lineContent = bufferRead.readLine()) != null) {
                byte[] bytes = lineContent.getBytes("GBK");
                String bankCode = Utils.subByteToStringForGbk((byte[])bytes, (int)0, (int)14).trim();
                String bankName = Utils.subByteToStringForGbk((byte[])bytes, (int)14, (int)119).trim();
                if (bankCode.length() < 8) continue;
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(BankCodeEo::getBankCode, (Object)bankCode);
                int count = this.bankCodeDas.count((Wrapper)queryWrapper);
                if (count != 0) continue;
                BankCodeEo bankCodeEo = new BankCodeEo();
                bankCodeEo.setBankCode(bankCode);
                bankCodeEo.setBankName(bankName);
                this.bankCodeDas.save((Object)bankCodeEo);
            }
        }
        catch (Exception e) {
            this.log.error("\u8bfb\u53d6\u4eba\u884c\u8054\u884c\u53f7\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void generateWithResult(String date) {
        File downloadFile;
        T21000007Request request = new T21000007Request();
        String fileName = this.citicProperties.getMchId() + CiticFileTypeEnum.WITH_RESULT.key + date + "01";
        request.setFILE_NAME(fileName);
        request.setFILE_TYPE(CiticFileTypeEnum.WITH_RESULT.key);
        request.setSETTLE_DT(date);
        String filePath = this.paymentProperties.getFileRootPath() + File.separator + CiticFileTypeEnum.WITH_RESULT.key + File.separator + date;
        String fullDownloadFilePath = filePath + File.separator + fileName;
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if ((downloadFile = new File(fullDownloadFilePath)).exists()) {
            this.log.info("e\u7ba1\u5bb6\u63d0\u73b0\u7ed3\u679c\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5982\u9700\u91cd\u8bd5\u8bf7\u5220\u9664\u6587\u4ef6");
            return;
        }
        this.log.info("\u6267\u884ce\u7ba1\u5bb6\u63d0\u73b0\u7ed3\u679c\u6587\u4ef6\u4e0b\u8f7d");
        T21000007Response response = this.citicPartnerService.T21000007(request);
        this.fileDownloadLogService.addFileLog(request, response);
        if (!"00000".equals(response.getRSP_CODE())) {
            this.log.error("e\u7ba1\u5bb6\u63d0\u73b0\u7ed3\u679c\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
            return;
        }
        if (StringUtils.isBlank((CharSequence)response.getFILE_CONTENT())) {
            this.log.error("e\u7ba1\u5bb6\u63d0\u73b0\u7ed3\u679c\u6587\u4ef6\u6682\u672a\u751f\u6210,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
            return;
        }
        Utils.decoderBase64File((String)response.getFILE_CONTENT(), (String)fullDownloadFilePath);
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(downloadFile), "GBK");
             BufferedReader bufferRead = new BufferedReader(read);){
            String lineContent;
            while ((lineContent = bufferRead.readLine()) != null) {
                byte[] bytes = lineContent.getBytes("GBK");
                String serialNo = Utils.subByteToStringForGbk((byte[])bytes, (int)245, (int)281).trim();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(WithResultEo::getSerialNo, (Object)serialNo);
                int count = this.withResultDas.count((Wrapper)queryWrapper);
                if (count != 0) continue;
                WithResultEo eo = new WithResultEo();
                eo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                eo.setUserId(Utils.subByteToStringForGbk((byte[])bytes, (int)0, (int)15).trim());
                eo.setUserName(Utils.subByteToStringForGbk((byte[])bytes, (int)15, (int)115).trim());
                eo.setTransDt(Utils.subByteToStringForGbk((byte[])bytes, (int)115, (int)123).trim());
                eo.setTransTm(Utils.subByteToStringForGbk((byte[])bytes, (int)123, (int)129).trim());
                eo.setBussId(Utils.subByteToStringForGbk((byte[])bytes, (int)129, (int)193).trim());
                eo.setWithAmt(Utils.subByteToStringForGbk((byte[])bytes, (int)193, (int)207).trim());
                eo.setWithFee(Utils.subByteToStringForGbk((byte[])bytes, (int)207, (int)221).trim());
                eo.setAdvanceAmt(Utils.subByteToStringForGbk((byte[])bytes, (int)221, (int)235).trim());
                eo.setWithBatchNo(Utils.subByteToStringForGbk((byte[])bytes, (int)235, (int)245).trim());
                eo.setSerialNo(Utils.subByteToStringForGbk((byte[])bytes, (int)245, (int)281).trim());
                eo.setWithAccountType(Utils.subByteToStringForGbk((byte[])bytes, (int)281, (int)282).trim());
                eo.setWithAccountName(Utils.subByteToStringForGbk((byte[])bytes, (int)282, (int)404).trim());
                eo.setWithAccount(Utils.subByteToStringForGbk((byte[])bytes, (int)404, (int)436).trim());
                eo.setWithResult(Utils.subByteToStringForGbk((byte[])bytes, (int)436, (int)437).trim());
                eo.setWithDesc(Utils.subByteToStringForGbk((byte[])bytes, (int)437, (int)637).trim());
                eo.setWithFeeType(Utils.subByteToStringForGbk((byte[])bytes, (int)637, (int)639).trim());
                this.withResultDas.save((Object)eo);
            }
        }
        catch (Exception e) {
            this.log.error("\u8bfb\u53d6\u63d0\u73b0\u7ed3\u679c\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void generateWithReturn(String date) {
        String fullDownloadFilePath;
        File downloadFile;
        T21000007Request request = new T21000007Request();
        String fileName = this.citicProperties.getMchId() + CiticFileTypeEnum.WITH_RETURN.key + date + "01";
        request.setFILE_NAME(fileName);
        request.setFILE_TYPE(CiticFileTypeEnum.WITH_RETURN.key);
        request.setSETTLE_DT(date);
        String filePath = this.paymentProperties.getFileRootPath() + File.separator + CiticFileTypeEnum.WITH_RETURN.key + File.separator + date;
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if ((downloadFile = new File(fullDownloadFilePath = filePath + File.separator + fileName)).exists()) {
            this.log.info("e\u7ba1\u5bb6\u9000\u6c47\u7ed3\u679c\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5982\u9700\u91cd\u8bd5\u8bf7\u5220\u9664\u6587\u4ef6");
            return;
        }
        this.log.info("\u6267\u884ce\u7ba1\u5bb6\u9000\u6c47\u7ed3\u679c\u6587\u4ef6\u4e0b\u8f7d");
        T21000007Response response = this.citicPartnerService.T21000007(request);
        this.fileDownloadLogService.addFileLog(request, response);
        if (!"00000".equals(response.getRSP_CODE())) {
            this.log.error("e\u7ba1\u5bb6\u9000\u6c47\u7ed3\u679c\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
            return;
        }
        if (StringUtils.isBlank((CharSequence)response.getFILE_CONTENT())) {
            this.log.error("e\u7ba1\u5bb6\u9000\u6c47\u7ed3\u679c\u6587\u4ef6\u6682\u672a\u751f\u6210,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
            return;
        }
        Utils.decoderBase64File((String)response.getFILE_CONTENT(), (String)fullDownloadFilePath);
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(fullDownloadFilePath), "GBK");
             BufferedReader bufferRead = new BufferedReader(read);){
            String lineContent;
            while ((lineContent = bufferRead.readLine()) != null) {
                byte[] bytes = lineContent.getBytes("GBK");
                String bussId = Utils.subByteToStringForGbk((byte[])bytes, (int)243, (int)307).trim();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(WithReturnEo::getBussId, (Object)bussId);
                int count = this.withReturnDas.count((Wrapper)queryWrapper);
                if (count != 0) continue;
                WithReturnEo eo = new WithReturnEo();
                eo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                eo.setUserId(Utils.subByteToStringForGbk((byte[])bytes, (int)0, (int)15).trim());
                eo.setUserName(Utils.subByteToStringForGbk((byte[])bytes, (int)15, (int)115).trim());
                eo.setReturnDt(Utils.subByteToStringForGbk((byte[])bytes, (int)115, (int)123).trim());
                eo.setReturnTm(Utils.subByteToStringForGbk((byte[])bytes, (int)123, (int)129).trim());
                eo.setReturnAmt(Utils.subByteToStringForGbk((byte[])bytes, (int)129, (int)143).trim());
                eo.setReturnReason(Utils.subByteToStringForGbk((byte[])bytes, (int)143, (int)243).trim());
                eo.setBussId(Utils.subByteToStringForGbk((byte[])bytes, (int)243, (int)307).trim());
                eo.setWithDt(Utils.subByteToStringForGbk((byte[])bytes, (int)307, (int)315).trim());
                eo.setWithAccountName(Utils.subByteToStringForGbk((byte[])bytes, (int)315, (int)437).trim());
                eo.setWithAccount(Utils.subByteToStringForGbk((byte[])bytes, (int)437, (int)469).trim());
                eo.setWithAmt(Utils.subByteToStringForGbk((byte[])bytes, (int)469, (int)483).trim());
                this.withReturnDas.save((Object)eo);
            }
        }
        catch (Exception e) {
            this.log.error("\u8bfb\u53d6\u9000\u6c47\u7ed3\u679c\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void generateAccountTransDetail(String date) {
        String fullDownloadFilePath;
        File downloadFile;
        T21000007Request request = new T21000007Request();
        String fileName = this.citicProperties.getMchId() + CiticFileTypeEnum.TRANS_DETAIL.key + date + "01";
        request.setFILE_NAME(fileName);
        String fileType = CiticFileTypeEnum.TRANS_DETAIL.key;
        request.setFILE_TYPE(fileType);
        request.setSETTLE_DT(date);
        String filePath = this.paymentProperties.getFileRootPath() + File.separator + CiticFileTypeEnum.TRANS_DETAIL.key + File.separator + date;
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if ((downloadFile = new File(fullDownloadFilePath = filePath + File.separator + fileName)).exists()) {
            this.log.info("e\u7ba1\u5bb6\u767b\u8bb0\u7c3f\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5982\u9700\u91cd\u8bd5\u8bf7\u5220\u9664\u6587\u4ef6");
            return;
        }
        this.log.info("\u6267\u884ce\u7ba1\u5bb6\u767b\u8bb0\u7c3f\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u4e0b\u8f7d");
        T21000007Response response = this.citicPartnerService.T21000007(request);
        this.fileDownloadLogService.addFileLog(request, response);
        if (!"00000".equals(response.getRSP_CODE())) {
            this.log.error("e\u7ba1\u5bb6\u767b\u8bb0\u7c3f\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
            return;
        }
        if (StringUtils.isBlank((CharSequence)response.getFILE_CONTENT())) {
            this.log.error("e\u7ba1\u5bb6\u767b\u8bb0\u7c3f\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u6682\u672a\u751f\u6210,code:{},msg:{},\u65e5\u671f\uff1a{}", new Object[]{response.getRSP_CODE(), response.getRSP_MSG(), date});
            return;
        }
        Utils.decoderBase64File((String)response.getFILE_CONTENT(), (String)fullDownloadFilePath);
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(fullDownloadFilePath), "GBK");
             BufferedReader bufferRead = new BufferedReader(read);){
            String lineContent;
            bufferRead.readLine();
            while ((lineContent = bufferRead.readLine()) != null) {
                byte[] bytes = lineContent.getBytes("GBK");
                String serialNo = Utils.subByteToStringForGbk((byte[])bytes, (int)332, (int)368).trim();
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(AccountTransDetailEo::getSerialNo, (Object)serialNo);
                int count = this.accountTransDetailDas.count((Wrapper)queryWrapper);
                if (count != 0) continue;
                AccountTransDetailEo eo = new AccountTransDetailEo();
                eo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                eo.setMchId(Utils.subByteToStringForGbk((byte[])bytes, (int)0, (int)15).trim());
                eo.setUserId(Utils.subByteToStringForGbk((byte[])bytes, (int)15, (int)30).trim());
                eo.setUserName(Utils.subByteToStringForGbk((byte[])bytes, (int)30, (int)152).trim());
                eo.setTransDt(Utils.subByteToStringForGbk((byte[])bytes, (int)152, (int)160).trim());
                eo.setTransTm(Utils.subByteToStringForGbk((byte[])bytes, (int)160, (int)166).trim());
                eo.setTransType(Utils.subByteToStringForGbk((byte[])bytes, (int)166, (int)168).trim());
                eo.setUserSsn(Utils.subByteToStringForGbk((byte[])bytes, (int)168, (int)204).trim());
                eo.setBussId(Utils.subByteToStringForGbk((byte[])bytes, (int)204, (int)268).trim());
                eo.setBussSubId(Utils.subByteToStringForGbk((byte[])bytes, (int)268, (int)332).trim());
                eo.setSerialNo(Utils.subByteToStringForGbk((byte[])bytes, (int)332, (int)368).trim());
                eo.setTransAmt(Utils.subByteToStringForGbk((byte[])bytes, (int)368, (int)382).trim());
                eo.setcDFlag(Utils.subByteToStringForGbk((byte[])bytes, (int)382, (int)383).trim());
                eo.setCurAmt(Utils.subByteToStringForGbk((byte[])bytes, (int)383, (int)397).trim());
                eo.setGoac(Utils.subByteToStringForGbk((byte[])bytes, (int)397, (int)429).trim());
                eo.setOanm(Utils.subByteToStringForGbk((byte[])bytes, (int)429, (int)549).trim());
                eo.setDigest(Utils.subByteToStringForGbk((byte[])bytes, (int)549, (int)649).trim());
                eo.setReserved(Utils.subByteToStringForGbk((byte[])bytes, (int)649, (int)849).trim());
                this.accountTransDetailDas.save((Object)eo);
            }
            this.log.info("\u8bfb\u53d6\u767b\u8bb0\u7c3f\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u7ed3\u675f");
        }
        catch (Exception e) {
            this.log.error("\u8bfb\u53d6\u767b\u8bb0\u7c3f\u4ea4\u6613\u660e\u7ec6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }
}

