/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransDetailQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransDetailUnverifiedQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticReturnResultBatchQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticTransStateQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.CiticWithResultBatchQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountTransDetailQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountTransDetailUnverifiedQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticBankCodesQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticFileDownloadResultQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticFileStateQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticReturnResultQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticTransStateQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticUserBalanceQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.CiticWithResultQueryResDto;
import com.dtyunxi.tcbj.api.query.ICiticQueryApi;
import com.dtyunxi.tcbj.biz.service.ICiticService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CiticQueryApiImpl
implements ICiticQueryApi {
    private static final Logger log = LoggerFactory.getLogger(CiticQueryApiImpl.class);
    @Resource
    private ICiticService citicService;

    public RestResponse<CiticUserBalanceQueryResDto> queryUserBalance(String userId) {
        return new RestResponse((Object)this.citicService.userBalanceQuery(userId));
    }

    public RestResponse<CiticTransStateQueryResDto> transStateQuery(CiticTransStateQueryReqDto dto) {
        return new RestResponse((Object)this.citicService.transStateQuery(dto));
    }

    public RestResponse<CiticFileStateQueryResDto> fileStateQuery(String fileName) {
        return new RestResponse((Object)this.citicService.fileStateQuery(fileName));
    }

    public RestResponse<CiticFileDownloadResultQueryResDto> fileDownloadResultQuery(String fileType, String settleDt) {
        return new RestResponse((Object)this.citicService.fileDownloadResultQuery(fileType, settleDt));
    }

    public RestResponse<List<CiticBankCodesQueryResDto>> bankCodesQuery(String bankCode, String bankName) {
        return new RestResponse(this.citicService.bankCodesQuery(bankCode, bankName));
    }

    public RestResponse<CiticBankCodesQueryResDto> queryByBankCode(String bankCode) {
        return new RestResponse((Object)this.citicService.queryByBankCode(bankCode));
    }

    public RestResponse<CiticWithResultQueryResDto> withResultQuery(String bussId) {
        return new RestResponse((Object)this.citicService.withResultQuery(bussId));
    }

    public RestResponse<List<CiticWithResultQueryResDto>> withResultBatchQuery(CiticWithResultBatchQueryReqDto dto) {
        return new RestResponse(this.citicService.withResultBatchQuery(dto));
    }

    public RestResponse<CiticReturnResultQueryResDto> returnResultQuery(String bussId) {
        return new RestResponse((Object)this.citicService.returnResultQuery(bussId));
    }

    public RestResponse<List<CiticReturnResultQueryResDto>> returnResultBatchQuery(CiticReturnResultBatchQueryReqDto dto) {
        return new RestResponse(this.citicService.returnResultBatchQuery(dto));
    }

    public RestResponse<List<CiticReturnResultQueryResDto>> withReturnTodoListQuery(Integer size) {
        return new RestResponse(this.citicService.withReturnTodoListQuery(size));
    }

    public RestResponse<List<CiticAccountTransDetailQueryResDto>> accountTransDetailQuery(CiticAccountTransDetailQueryReqDto dto) {
        return new RestResponse(this.citicService.accountTransDetailQuery(dto));
    }

    public RestResponse<List<CiticAccountTransDetailUnverifiedQueryResDto>> accountTransDetailUnverifiedQuery(CiticAccountTransDetailUnverifiedQueryReqDto dto) {
        return new RestResponse(this.citicService.accountTransDetailUnverifiedQuery(dto));
    }
}

