/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.tcbj.api.dto.request.SplitOrderAddReqDto;
import com.dtyunxi.tcbj.api.dto.request.SplitOrderClearReqDto;
import com.dtyunxi.tcbj.api.dto.request.SplitOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAddSplitOrderBatchResDto;
import com.dtyunxi.tcbj.api.dto.response.SplitOrderRespDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticFileStateEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticFileTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticRspCodeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticSplitDealStatusEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticSplitOrderResultEnum;
import com.dtyunxi.tcbj.biz.config.PaymentProperties;
import com.dtyunxi.tcbj.biz.service.IFileDownloadLogService;
import com.dtyunxi.tcbj.biz.service.ISplitOrderService;
import com.dtyunxi.tcbj.dao.das.SplitLogDas;
import com.dtyunxi.tcbj.dao.das.SplitOrderDas;
import com.dtyunxi.tcbj.dao.eo.SplitLogEo;
import com.dtyunxi.tcbj.dao.eo.SplitOrderEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.config.CiticProperties;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000007Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000008Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.request.T21000012Request;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000007Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000008Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.domain.response.T21000012Response;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.service.ICiticPartnerService;
import com.dtyunxi.yundt.cube.center.payment.service.partner.citic.util.Utils;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SplitOrderServiceImpl
implements ISplitOrderService {
    Logger log = LoggerFactory.getLogger(SplitOrderServiceImpl.class);
    @Resource
    private SplitOrderDas splitOrderDas;
    @Resource
    private SplitLogDas splitLogDas;
    @Resource
    private PaymentProperties paymentProperties;
    @Resource
    private CiticProperties citicProperties;
    @Resource
    private ICiticPartnerService citicPartnerService;
    @Resource
    private IFileDownloadLogService fileDownloadLogService;
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmss");

    @Override
    public Long addSplitOrder(SplitOrderAddReqDto addReqDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SplitOrderEo::getBussSubId, (Object)addReqDto.getBussSubId());
        SplitOrderEo record = (SplitOrderEo)this.splitOrderDas.getOne((Wrapper)queryWrapper);
        if (record != null) {
            return record.getId();
        }
        SplitOrderEo splitOrderEo = new SplitOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)splitOrderEo);
        this.splitOrderDas.insert((BaseEo)splitOrderEo);
        return splitOrderEo.getId();
    }

    @Override
    @Transactional
    public List<CiticAddSplitOrderBatchResDto> addSplitOrderBatch(List<SplitOrderAddReqDto> list) {
        ArrayList<CiticAddSplitOrderBatchResDto> resDtoList = new ArrayList<CiticAddSplitOrderBatchResDto>();
        for (SplitOrderAddReqDto addReqDto : list) {
            CiticAddSplitOrderBatchResDto resDto = new CiticAddSplitOrderBatchResDto();
            resDto.setBussSubId(addReqDto.getBussSubId());
            Long recordId = this.addSplitOrder(addReqDto);
            resDto.setRecordId(recordId);
            resDtoList.add(resDto);
        }
        return resDtoList;
    }

    @Override
    public SplitOrderRespDto queryById(Long id) {
        SplitOrderEo splitOrderEo = (SplitOrderEo)this.splitOrderDas.selectByPrimaryKey(id);
        SplitOrderRespDto splitOrderRespDto = new SplitOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)splitOrderEo, (BaseVo)splitOrderRespDto);
        return splitOrderRespDto;
    }

    @Override
    public PageInfo<SplitOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SplitOrderReqDto splitOrderReqDto = (SplitOrderReqDto)JSON.parseObject((String)filter, SplitOrderReqDto.class);
        SplitOrderEo splitOrderEo = new SplitOrderEo();
        DtoHelper.dto2Eo((BaseVo)splitOrderReqDto, (BaseEo)splitOrderEo);
        PageInfo eoPageInfo = this.splitOrderDas.selectPage((BaseEo)splitOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SplitOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void splitOrderClear(SplitOrderClearReqDto dto) {
        LocalDate splitDate = LocalDate.parse(dto.getSplitDt(), this.dateFormatter);
        if (!splitDate.isBefore(LocalDate.now())) {
            throw new BizException("\u6e05\u5206\u8bf7\u6c42\u5931\u8d25\uff1a\u53ea\u80fd\u6e05\u5206\u4eca\u5929\u4ee5\u524d\u7684\u8ba2\u5355");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SplitLogEo::getSplitDt, (Object)dto.getSplitDt());
        SplitLogEo eo = (SplitLogEo)this.splitLogDas.getOne((Wrapper)queryWrapper);
        if (eo == null) {
            SplitLogEo insert = new SplitLogEo();
            insert.setSplitDt(dto.getSplitDt());
            insert.setSplitDtSet(dto.getSplitDtSet());
            insert.setDealStatus(CiticSplitDealStatusEnum.UPLOAD_WAITING.key);
            this.splitLogDas.insert((BaseEo)insert);
        }
    }

    @Override
    public void uploadSplitOrder(String tradeDate) {
        this.log.info("\u4e0a\u4f20\u5206\u8d26\u8ba2\u5355\u5230\u4e2d\u4fe1\u8fdb\u884c\u6e05\u5206\u5904\u7406\uff1a{}", (Object)tradeDate);
        LambdaQueryWrapper logErrWrapper = new LambdaQueryWrapper();
        logErrWrapper.eq(SplitLogEo::getDealStatus, (Object)CiticSplitDealStatusEnum.PROCESSING.key);
        logErrWrapper.eq(BaseEo::getDr, (Object)0);
        int errCount = this.splitLogDas.count((Wrapper)logErrWrapper);
        if (errCount > 0) {
            this.log.info("\u5b58\u5728\u672a\u5b8c\u6210\u6e05\u5206\u7684\u8bb0\u5f55\uff0c\u5f85\u672a\u5b8c\u6210\u7684\u8bb0\u5f55\u6e05\u5206\u540e\u624d\u80fd\u7ee7\u7eed\u64cd\u4f5c");
            return;
        }
        LambdaQueryWrapper logQueryWrapper = new LambdaQueryWrapper();
        logQueryWrapper.eq(BaseEo::getDr, (Object)0);
        logQueryWrapper.eq(SplitLogEo::getDealStatus, (Object)CiticSplitDealStatusEnum.UPLOAD_WAITING.key);
        if (StringUtils.isNotBlank((CharSequence)tradeDate)) {
            logQueryWrapper.eq(SplitLogEo::getSplitDt, (Object)tradeDate);
        } else {
            logQueryWrapper.lt(SplitLogEo::getSplitDt, (Object)this.dateFormatter.format(LocalDate.now()));
        }
        logQueryWrapper.orderByAsc(SplitLogEo::getSplitDt);
        logQueryWrapper.last("limit 1");
        SplitLogEo logEo = (SplitLogEo)this.splitLogDas.getOne((Wrapper)logQueryWrapper);
        if (logEo == null) {
            this.log.info("\u672a\u67e5\u8be2\u5230\u5f85\u4e0a\u4f20\u6587\u4ef6\u7684\u6e05\u5206\u4efb\u52a1\uff0c\u64cd\u4f5c\u7ed3\u675f");
            return;
        }
        String date = logEo.getSplitDt();
        List<String> dateList = Arrays.asList(logEo.getSplitDtSet().split(","));
        this.log.info("\u6d89\u53ca\u7684\u4ea4\u6613\u65e5\u671f\uff1a{}", (Object)JSON.toJSONString(dateList));
        LambdaQueryWrapper orderQueryWrapper = new LambdaQueryWrapper();
        orderQueryWrapper.eq(BaseEo::getDr, (Object)0);
        orderQueryWrapper.in(SplitOrderEo::getTransDt, dateList);
        orderQueryWrapper.eq(SplitOrderEo::getDealStatus, (Object)0);
        List<SplitOrderEo> orderList = this.splitOrderDas.list((Wrapper)orderQueryWrapper);
        orderList = this.filterInvalidOrder(orderList);
        if (orderList.isEmpty()) {
            this.log.info("\u672a\u67e5\u8be2\u5230\u5f85\u4e0a\u4f20\u7684\u5206\u8d26\u8ba2\u5355\u660e\u7ec6\uff0c\u64cd\u4f5c\u7ed3\u675f");
            SplitLogEo updateLog = new SplitLogEo();
            updateLog.setId(logEo.getId());
            updateLog.setSplitStatus(CiticFileStateEnum.CLEAR_SUCCESS.key);
            updateLog.setResultCode(CiticRspCodeEnum.SUCCESS.key);
            updateLog.setResultMsg(CiticRspCodeEnum.SUCCESS.label);
            updateLog.setDealStatus(CiticSplitDealStatusEnum.COMPLETE.key);
            updateLog.setExtension("\u81ea\u52a8\u5b8c\u6210\u5206\u8d26");
            this.splitLogDas.updateSelective((BaseEo)updateLog);
            return;
        }
        this.log.info("\u5f00\u59cb\u6267\u884c\u672c\u6b21\u6e05\u5206\u64cd\u4f5c\uff0c\u6e05\u5206\u65e5\u671f\uff1a{}", (Object)date);
        this.log.info("\u5f00\u59cb\u6267\u884c\u672c\u6b21\u6e05\u5206\u64cd\u4f5c\uff0c\u6e05\u5206\u65e5\u671f\uff1a{}", (Object)JSON.toJSONString(orderList));
        String filePath = this.paymentProperties.getFileRootPath() + File.separator + CiticFileTypeEnum.ORDERS.key + File.separator + date;
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        String fileName = this.citicProperties.getMchId() + this.citicProperties.getPayChannel() + CiticFileTypeEnum.ORDERS.key + date + "01";
        String fullFilePath = filePath + File.separator + fileName;
        File ordersFile = new File(fullFilePath);
        if (ordersFile.exists()) {
            this.log.info("\u5220\u9664\u65e7\u8ba2\u5355\u660e\u7ec6\u6587\u4ef6\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)fullFilePath);
            ordersFile.delete();
        }
        this.log.info("\u5f00\u59cb\u751f\u6210\u8ba2\u5355\u660e\u7ec6\u6587\u4ef6\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)fullFilePath);
        Utils.stringToFile((String)this.generateSplitOrdersStr(orderList), (String)fullFilePath);
        this.log.info("\u8ba2\u5355\u660e\u7ec6\u6587\u4ef6\u5199\u5165\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)fullFilePath);
        String zipFileName = fileName + ".ZIP";
        String zipFileFullPath = filePath + File.separator + zipFileName;
        File ordersZipFile = new File(zipFileFullPath);
        if (ordersZipFile.exists()) {
            this.log.info("\u5220\u9664\u65e7\u8ba2\u5355\u660e\u7ec6\u538b\u7f29\u6587\u4ef6\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)zipFileFullPath);
            ordersZipFile.delete();
        }
        this.log.info("\u5f00\u59cb\u538b\u7f29\u8ba2\u5355\u660e\u7ec6\u6587\u4ef6\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)zipFileFullPath);
        Utils.fileZip((File)ordersFile, (File)ordersZipFile);
        this.log.info("\u538b\u7f29\u8ba2\u5355\u660e\u7ec6\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)zipFileFullPath);
        String fileContent = Utils.encodeBase64File((String)zipFileFullPath).replace("\r\n", "");
        T21000008Request request = new T21000008Request();
        request.setFILE_COUNT(orderList.size() + "");
        request.setFILE_TYPE(CiticFileTypeEnum.ORDERS.key);
        request.setFILE_NAME(zipFileName);
        request.setFILE_CONTENT(fileContent);
        request.setTRANS_TYPE("MSG");
        T21000008Response response = this.citicPartnerService.T21000008(request);
        SplitLogEo updateLog = new SplitLogEo();
        updateLog.setId(logEo.getId());
        if (!"00000".equals(response.getRSP_CODE())) {
            this.log.error("\u6e05\u5206\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff0c\u6e05\u5206\u65e5\u671f:{},rspCode:{},rspMsg:{}", new Object[]{date, response.getRSP_CODE(), response.getRSP_MSG()});
            updateLog.setResultCode(response.getRSP_CODE());
            updateLog.setResultMsg(response.getRSP_MSG());
            this.splitLogDas.updateSelective((BaseEo)updateLog);
            return;
        }
        updateLog.setResultCode(response.getRESULT_CODE());
        updateLog.setResultMsg(response.getRESULT_MSG());
        updateLog.setDealStatus(CiticSplitDealStatusEnum.PROCESSING.key);
        this.splitLogDas.updateSelective((BaseEo)updateLog);
        this.log.info("\u6e05\u5206\u64cd\u4f5c\u6210\u529f\uff0c\u6e05\u5206\u65e5\u671f:{},resultCode:{},resultMsg:{}", new Object[]{date, response.getRESULT_CODE(), response.getRESULT_MSG()});
    }

    private List<SplitOrderEo> filterInvalidOrder(List<SplitOrderEo> orderList) {
        if (CollectionUtil.isEmpty(orderList)) {
            return orderList;
        }
        this.log.info("\u8fc7\u6ee4\u65e0\u6548\u5355\u636e\uff0c\u5373\u652f\u4ed8\u4e0e\u9000\u6b3e\u540c\u65f6\u5b58\u5728\u7684\u5355\u636e\u79fb\u9664\uff1a{}", orderList);
        Map<String, List<SplitOrderEo>> collect = orderList.stream().collect(Collectors.groupingBy(d -> d.getTransDt() + d.getPayNo() + d.getPayAmt() + d.getUserId()));
        ArrayList<SplitOrderEo> filterList = new ArrayList<SplitOrderEo>();
        String dealDate = this.dateFormat.format(new Date());
        String dealTime = this.timeFormat.format(new Date());
        collect.forEach((k, v) -> {
            if (v.size() == 1) {
                filterList.addAll((Collection<SplitOrderEo>)v);
            } else {
                v.forEach(order -> {
                    SplitOrderEo updateSplitOrderEo = new SplitOrderEo();
                    updateSplitOrderEo.setId(order.getId());
                    updateSplitOrderEo.setDealDt(dealDate);
                    updateSplitOrderEo.setDealTm(dealTime);
                    updateSplitOrderEo.setDealResult(CiticSplitOrderResultEnum.SUCCESS.key);
                    updateSplitOrderEo.setDealResultDesc("\u6210\u529f");
                    updateSplitOrderEo.setRemark("\u65e0\u6548\u5355\u636e\uff0c\u81ea\u52a8\u5206\u8d26");
                    this.splitOrderDas.updateSelective((BaseEo)updateSplitOrderEo);
                });
            }
        });
        return filterList;
    }

    private String generateSplitOrdersStr(List<SplitOrderEo> orderList) {
        StringBuilder sb = new StringBuilder();
        for (SplitOrderEo order : orderList) {
            sb.append(Utils.addBlankForText((String)this.citicProperties.getMchId(), (int)15));
            sb.append(Utils.addBlankForText((String)order.getUserId(), (int)15));
            sb.append(Utils.addBlankForText((String)order.getTransDt(), (int)8));
            sb.append(Utils.addBlankForText((String)order.getTransTm(), (int)6));
            sb.append(Utils.addBlankForText((String)this.citicProperties.getPayChannel(), (int)60));
            sb.append(Utils.addBlankForText((String)order.getBussId(), (int)64));
            sb.append(Utils.addBlankForText((String)order.getPayNo(), (int)64));
            String delimiter = new String(new byte[]{3});
            sb.append(Utils.addBlankForText((String)order.getPayChannelSsn(), (int)64));
            sb.append(Utils.addBlankForText((String)order.getBussSubId(), (int)64));
            sb.append(Utils.addBlankForText((String)order.getPayTransTp(), (int)2));
            sb.append(Utils.addBlankForText((String)order.getBussTransTp(), (int)2));
            sb.append(Utils.addBlankForText((String)order.getFundSource(), (int)1));
            sb.append(Utils.addBlankForText((String)order.getFeeTp(), (int)1));
            String orderAmt = new BigDecimal(order.getOrderAmt()).multiply(new BigDecimal(100)).setScale(0, 4).toString();
            sb.append(Utils.addZeroForAmt((String)orderAmt, (int)14));
            String payAmt = new BigDecimal(order.getPayAmt()).multiply(new BigDecimal(100)).setScale(0, 4).toString();
            sb.append(Utils.addZeroForAmt((String)payAmt, (int)14));
            String discountAmt = new BigDecimal(order.getDiscountAmt()).multiply(new BigDecimal(100)).setScale(0, 4).toString();
            sb.append(Utils.addZeroForAmt((String)discountAmt, (int)14));
            String shareAmt = new BigDecimal(order.getShareAmt()).multiply(new BigDecimal(100)).setScale(0, 4).toString();
            sb.append(Utils.addZeroForAmt((String)shareAmt, (int)14));
            String advanceAmt = new BigDecimal(order.getAdvanceAmt()).multiply(new BigDecimal(100)).setScale(0, 4).toString();
            sb.append(Utils.addZeroForAmt((String)advanceAmt, (int)14));
            String feeAmt = new BigDecimal(order.getFeeAmt()).multiply(new BigDecimal(100)).setScale(0, 4).toString();
            sb.append(Utils.addZeroForAmt((String)feeAmt, (int)14));
            sb.append(Utils.addBlankForText((String)order.getFundTp(), (int)6));
            sb.append(Utils.addBlankForText((String)order.getRemark(), (int)200));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    @Override
    @Transactional
    public void refreshOrderState() {
        this.log.info("\u5f00\u59cb\u6267\u884c\u6587\u4ef6\u5904\u7406\u72b6\u6001\u5237\u65b0");
        LambdaQueryWrapper logQueryWrapper = new LambdaQueryWrapper();
        logQueryWrapper.eq(SplitLogEo::getDealStatus, (Object)CiticSplitDealStatusEnum.PROCESSING.key);
        List list = this.splitLogDas.list((Wrapper)logQueryWrapper);
        if (list.isEmpty()) {
            this.log.info("\u6682\u65e0\u5f85\u66f4\u65b0\u72b6\u6001\u7684\u6e05\u5206\u8bb0\u5f55");
            return;
        }
        for (SplitLogEo eo : list) {
            String fileName = this.citicProperties.getMchId() + this.citicProperties.getPayChannel() + CiticFileTypeEnum.ORDERS.key + eo.getSplitDt() + "01";
            T21000012Request request = new T21000012Request();
            request.setFILE_NAME(fileName);
            T21000012Response response = this.citicPartnerService.T21000012(request);
            SplitLogEo update = new SplitLogEo();
            update.setId(eo.getId());
            if (!"00000".equals(response.getRSP_CODE())) {
                this.log.info("\u66f4\u65b0\u5206\u8d26\u6587\u4ef6\u72b6\u6001\u5931\u8d25\uff0crspCode:{},rspCode:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
                update.setResultCode(response.getRSP_CODE());
                update.setResultMsg(response.getRSP_MSG());
                this.splitLogDas.updateSelective((BaseEo)update);
                return;
            }
            update.setSplitStatus(response.getFILE_ST());
            update.setResultCode(response.getRESULT_CODE());
            update.setResultMsg(response.getRESULT_MSG());
            if (CiticFileStateEnum.CLEAR_SUCCESS.key.equals(response.getFILE_ST())) {
                update.setDealStatus(CiticSplitDealStatusEnum.COMPLETE.key);
                LambdaQueryWrapper orderQueryWrapper = new LambdaQueryWrapper();
                orderQueryWrapper.eq(BaseEo::getDr, (Object)0);
                if (StringUtils.isNotBlank((CharSequence)eo.getSplitDtSet())) {
                    String[] split = eo.getSplitDtSet().split(",");
                    orderQueryWrapper.in(SplitOrderEo::getTransDt, Arrays.asList(split));
                } else {
                    orderQueryWrapper.eq(SplitOrderEo::getTransDt, (Object)eo.getSplitDt());
                }
                List splitOrders = this.splitOrderDas.list((Wrapper)orderQueryWrapper);
                if (!splitOrders.isEmpty()) {
                    for (SplitOrderEo splitOrder : splitOrders) {
                        if (!StringUtils.isBlank((CharSequence)splitOrder.getDealResult()) && splitOrder.getDealResult().equals(CiticSplitOrderResultEnum.SUCCESS.key)) continue;
                        SplitOrderEo updateOrder = new SplitOrderEo();
                        updateOrder.setId(splitOrder.getId());
                        updateOrder.setDealStatus(CiticSplitDealStatusEnum.COMPLETE.key);
                        updateOrder.setDealResult(CiticSplitOrderResultEnum.SUCCESS.key);
                        updateOrder.setDealResultDesc("\u6210\u529f");
                        this.splitOrderDas.updateSelective((BaseEo)updateOrder);
                    }
                }
            }
            this.splitLogDas.updateSelective((BaseEo)update);
        }
    }

    @Override
    public void downloadSplitOrderResult(String date) {
        String fullDownloadFilePath;
        File downloadFile;
        T21000007Request request = new T21000007Request();
        String fileName = this.citicProperties.getMchId() + this.citicProperties.getPayChannel() + CiticFileTypeEnum.ORDERS_RESULT.key + date + "01";
        request.setFILE_NAME(fileName);
        request.setFILE_TYPE(CiticFileTypeEnum.ORDERS_RESULT.key);
        request.setSETTLE_DT(date);
        String filePath = this.paymentProperties.getFileRootPath() + File.separator + CiticFileTypeEnum.ORDERS_RESULT.key + File.separator + date;
        File fileDir = new File(filePath);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        if ((downloadFile = new File(fullDownloadFilePath = filePath + File.separator + fileName)).exists()) {
            this.log.info("\u6267\u884ce\u7ba1\u5bb6\u8ba2\u5355\u660e\u7ec6\u7ed3\u679c\u538b\u7f29\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5982\u9700\u91cd\u8bd5\u8bf7\u5220\u9664\u6587\u4ef6");
            return;
        }
        this.log.info("\u6267\u884ce\u7ba1\u5bb6\u8ba2\u5355\u660e\u7ec6\u7ed3\u679c\u6587\u4ef6\u4e0b\u8f7d");
        T21000007Response response = this.citicPartnerService.T21000007(request);
        this.fileDownloadLogService.addFileLog(request, response);
        if (!"00000".equals(response.getRSP_CODE())) {
            this.log.error("e\u7ba1\u5bb6\u8ba2\u5355\u660e\u7ec6\u7ed3\u679c\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
            return;
        }
        if (StringUtils.isBlank((CharSequence)response.getFILE_CONTENT())) {
            this.log.error("e\u7ba1\u5bb6\u8ba2\u5355\u660e\u7ec6\u7ed3\u679c\u6587\u4ef6\u6682\u672a\u751f\u6210,code:{},msg:{}", (Object)response.getRSP_CODE(), (Object)response.getRSP_MSG());
            return;
        }
        Utils.decoderBase64File((String)response.getFILE_CONTENT(), (String)fullDownloadFilePath);
    }
}

