/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.jobs.tasks;

import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.tcbj.biz.service.ICiticService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="withReturnSync")
@Scope(value="prototype")
public class CiticWithReturnSyncJob
extends SingleTupleScheduleEvent {
    Logger log = LoggerFactory.getLogger(CiticWithReturnSyncJob.class);
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    @Resource
    private ICiticService citicService;

    public void syncWithReturn() {
        long startTime = System.currentTimeMillis();
        this.log.info("\u5f00\u59cb\u6267\u884c\u9000\u6c47\u7ed3\u679c\u6570\u636e\u540c\u6b65\u4efb\u52a1,\u5f00\u59cb\u65f6\u95f4:{}", (Object)startTime);
        int exeDays = 5;
        for (int i = 1; i <= exeDays; ++i) {
            LocalDate localDate = LocalDate.now().minusDays(i);
            String date = this.dateFormatter.format(localDate);
            this.citicService.generateWithReturn(date);
        }
        long endTime = System.currentTimeMillis();
        this.log.info("\u6267\u884c\u9000\u6c47\u7ed3\u679c\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u675f,\u8017\u65f6:{} ms", (Object)(endTime - startTime));
    }

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        this.syncWithReturn();
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

