package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 销售订单统计dto
 *
 * @author haoxiao
 * @since 2022-03-10
 */
@Data
@ApiModel(value = "SaleOrderCountRespDto", description = "销售订单统计dto")
public class SaleOrderCountRespDto {
    /**
     * 待确认数量
     */
    @ApiModelProperty(name = "waitCheckCount", value = "待确认数量")
    private BigDecimal waitCheckCount;
    /**
     * 待配货数量
     */
    @ApiModelProperty(name = "waitPickCount", value = "待配货数量")
    private BigDecimal waitPickCount;
    /**
     * 已锁未发/已配货数量
     */
    @ApiModelProperty(name = "lockUnDeliveryCount", value = "已锁未发/已配货数量")
    private BigDecimal lockUnDeliveryCount;

    /**
     * 待发货数量
     */
    @ApiModelProperty(name = "waitDeliveryCount", value = "待发货数量")
    private BigDecimal waitDeliveryCount;

    /**
     * 已发货数量
     */
    @ApiModelProperty(name = "deliveredCount", value = "已发货数量")
    private BigDecimal deliveredCount;

    /**
     * 已完成数量
     */
    @ApiModelProperty(name = "completeCount", value = "已完成数量")
    private BigDecimal completeCount;

    /**
     * 已取消数量
     */
    @ApiModelProperty(name = "cancelCount", value = "已取消数量")
    private BigDecimal cancelCount;
    /**
     * 已取消数量
     */
    @ApiModelProperty(name = "cancelingCount", value = "取消中数量")
    private BigDecimal cancelingCount;

    /**
     * 已完结数量
     */
    @ApiModelProperty(name = "finishCount", value = "已完结数量")
    private BigDecimal finishCount;

    /**
     * 被拆分数量
     */
    @ApiModelProperty(name = "splitCount", value = "被拆分数量\n")
    private BigDecimal splitCount;

    /**
     * 全部数量
     */
    @ApiModelProperty(name = "allCount", value = "全部数量")
    private BigDecimal allCount;

}
