package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
* 库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录Eo对象
*
* @author wude
* @since 2022-03-11
*/
@Data
@ApiModel(value = "InventoryOperateLogReqDto", description = "库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录Eo对象")
public class InventoryOperateLogReqDto extends BaseDto {


    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓
    */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  单据类型,待定
    */
    @ApiModelProperty(name = "sourceType", value = "单据类型,待定")
    private String sourceType;
    /**
    *  来源单据号
    */
    @ApiModelProperty(name = "sourceNo", value = "来源单据号")
    private String sourceNo;

    /**
    *  变动类型
    */
    @ApiModelProperty(name = "changeType", value = "变动类型")
    private String changeType;
    /**
     * 变更开始时间
     */
    @ApiModelProperty(
            name = "changeBeginTime",
            value = "变更开始时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date changeBeginTime;
    /**
     * 变更结束时间
     */
    @ApiModelProperty(
            name = "changeEndTime",
            value = "变更结束时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date changeEndTime;

   
    /**
     *  业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
}
