package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

/**
* 平台订单dto
*
* @author haoxiao
* @since 2022-03-10
*/
@Data
@ApiModel(value = "PlatformOrderRespDto", description = "平台订单dto")
public class PlatformOrderRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  平台订单号
    */
    @ApiModelProperty(name = "platformOrderNo", value = "平台订单号")
    private String platformOrderNo;
    /**
    *  平台父订单号
    */
    @ApiModelProperty(name = "platformParentOrderNo", value = "平台父订单号")
    private String platformParentOrderNo;
    /**
    *  平台下单时间
    */
    @ApiModelProperty(name = "platformCreateTime", value = "平台下单时间")
    private Date platformCreateTime;
    /**
    *  订单类型 0-大B订单 1-积分订单 2-普通订单
    */
    @ApiModelProperty(name = "orderType", value = "订单类型 0-大B订单 1-积分订单 2-普通订单")
    private Integer orderType;
    /**
    *  内部订单号
    */
    @ApiModelProperty(name = "saleOrderNo", value = "内部订单号")
    private String saleOrderNo;
    /**
    *  转单状态 0-正常 1-异常 2-作废
    */
    @ApiModelProperty(name = "transferOrderStatus", value = "转单状态 0-正常 1-异常 2-作废")
    private Integer transferOrderStatus;
    /**
    *  转单时间
    */
    @ApiModelProperty(name = "transferOrderTime", value = "转单时间")
    private Date transferOrderTime;
    /**
    *  异常原因
    */
    @ApiModelProperty(name = "exceptionReason", value = "异常原因")
    private String exceptionReason;
    /**
    *  店铺id
    */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private String shopId;
    /**
     *  店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
    *  店铺渠道
    */
    @ApiModelProperty(name = "shopChannel", value = "店铺渠道")
    private String shopChannel;
    /**
    *   订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
    */
    @ApiModelProperty(name = "orderSource", value = " 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private Integer orderSource;
    /**
    *  销售订单创建时间
    */
    @ApiModelProperty(name = "saleCreateTime", value = "销售订单创建时间")
    private Date saleCreateTime;
    /**
    *  订单来源：0：线下 1: 线上
    */
    @ApiModelProperty(name = "isOnline", value = "订单来源：0：线下 1: 线上")
    private Integer isOnline;
    /**
    *  经销渠道
    */
    @ApiModelProperty(name = "saleChannel", value = "经销渠道")
    private String saleChannel;
    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
    *  客户名称
    */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
    *  作废人
    */
    @ApiModelProperty(name = "obsoletePerson", value = "作废人")
    private String obsoletePerson;
    /**
    *  作废时间
    */
    @ApiModelProperty(name = "obsoleteTime", value = "作废时间")
    private Date obsoleteTime;
    /**
    *  作废原因
    */
    @ApiModelProperty(name = "obsoleteReason", value = "作废原因")
    private String obsoleteReason;
    /**
    *  商品总数量
    */
    @ApiModelProperty(name = "goodsTotalNum", value = "商品总数量")
    private Integer goodsTotalNum;
    /**
    *  商品总金额
    */
    @ApiModelProperty(name = "goodsTotalAmount", value = "商品总金额")
    private BigDecimal goodsTotalAmount;
    /**
    *  应付金额
    */
    @ApiModelProperty(name = "orderTotalAmount", value = "应付金额")
    private BigDecimal orderTotalAmount;
    /**
    *  实付金额
    */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;
    /**
    *  支付时间
    */
    @ApiModelProperty(name = "payTime", value = "支付时间")
    private Date payTime;
    /**
    *  支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付
    */
    @ApiModelProperty(name = "payWay", value = "支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付")
    private String payWay;
    /**
    *  支付状态（0-未支付、1-已支付）
    */
    @ApiModelProperty(name = "payStatus", value = "支付状态（0-未支付、1-已支付）")
    private Integer payStatus;
    /**
    *  订单备注 
    */
    @ApiModelProperty(name = "remark", value = "订单备注 ")
    private String remark;
    /**
    *  商家备注
    */
    @ApiModelProperty(name = "sellerRemark", value = "商家备注")
    private String sellerRemark;


    /**
     *  收货人姓名
     */
    @ApiModelProperty(name = "receiveName", value = "收货人姓名")
    private String receiveName;
    /**
     *  收货人手机号
     */
    @ApiModelProperty(name = "receivePhone", value = "收货人手机号")
    private String receivePhone;

    /**
     * 地址、区域实体
     */
    @ApiModelProperty(name = "orderAddress", value = "地址、区域实体")
    private CommonAddrRespDto orderAddress;
    /**
     *  平台订单创建人
     */
    @ApiModelProperty(name = "platformOrderCreatePerson", value = "平台订单创建人")
    private String platformOrderCreatePerson;

}
