package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 发货结果单服务接口
*
* @author wude
* @since 2022-03-08
*/
@Api(tags = {"发货结果单服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/deliveryResultOrder", url = "${tcbj.center.report.api:}")
public interface IDeliveryResultOrderQueryApi {

    /**
    * 根据id查询发货结果单
    *
    * @param id 发货结果单id
    * @return   发货结果单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询发货结果单", notes = "根据id查询发货结果单")
    RestResponse<DeliveryResultOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 发货结果单分页数据
    *
    * @param filter   发货结果单查询条件
    * @return 发货结果单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "发货结果单分页数据", notes = "根据filter查询条件查询发货结果单数据，filter=DeliveryResultOrderReqDto")
    RestResponse<PageInfo<DeliveryResultOrderRespDto>> queryByPage(@RequestBody DeliveryResultOrderReqDto filter);

}
