package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

/**
* 销售订单dto
*
* @author haoxiao
* @since 2022-03-10
*/
@Data
@ApiModel(value = "SaleOrderRespDto", description = "销售订单dto")
public class SaleOrderRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    @ApiModelProperty(name ="platformOrderNo",value = "平台订单号")
    private String platformOrderNo;

    @ApiModelProperty(name ="saleOrderNo",value = "内部销售订单号")
    private String saleOrderNo;

    @ApiModelProperty(name ="orderLevel",value = "订单级别（0原、1主、2子）")
    private Integer orderLevel;

    @ApiModelProperty(name ="shopName",value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name ="shopChannel",value = "店铺渠道")
    private String shopChannel;

    @ApiModelProperty(name ="customerName",value = "客户名称")
    private String customerName;

    @ApiModelProperty(name ="orderRemark",value = "订单备注")
    private String orderRemark;

    @ApiModelProperty(name ="sellerRemark",value = "商家备注")
    private String sellerRemark;

    /**
     * 地址、区域实体
     */
    @ApiModelProperty(name = "orderAddress", value = "地址、区域实体")
    private CommonAddrRespDto orderAddress;

    @ApiModelProperty(name ="deliveryName",value = "收件人姓名")
    private String deliveryName;

    @ApiModelProperty(name ="deliveryPhone",value = "收件人电话")
    private String deliveryPhone;

    @ApiModelProperty(name ="platformCreateTime",value = "平台创建时间/下单时间")
    private Date platformCreateTime;

    @ApiModelProperty(name ="saleOrderCreateTime",value = "内部销售订单创建时间")
    private Date saleOrderCreateTime;

    @ApiModelProperty(name ="confirmReceiveTime",value = "确认收货时间")
    private Date confirmReceiveTime;

    @ApiModelProperty(name ="needHandleReason",value = "需人工操作原因")
    private String needHandleReason;

    /**
     *  支付方式，0-支付宝 1-微信 2-银联
     */
    @ApiModelProperty(name = "payWay", value = "支付方式，0-支付宝 1-微信 2-银联")
    private Integer payWay;
    /**
     *  支付状态（0-未支付、1-已支付）
     */
    @ApiModelProperty(name = "payStatus", value = "支付状态（0-未支付、1-已支付）")
    private Integer payStatus;

    /**
     * 订单类型 0-大B订单 1-积分订单
     */
    @ApiModelProperty(name ="orderType",value = "订单类型 0-大B订单 1-积分订单")
    private String orderType;

    @ApiModelProperty(name ="cancelReason",value = "取消原因")
    private String cancelReason;

    @ApiModelProperty(name ="goodsTotalNum",value = "明细数量汇总（商品总数量）")
    private BigDecimal goodsTotalNum;

    @ApiModelProperty(name ="orderSource",value = "订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private String orderSource;
    /**
     *  订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分
     */
    @ApiModelProperty(name = "saleOrderStatus", value = "订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分")
    private String saleOrderStatus;

    @ApiModelProperty(name ="bunchCodeFlag",value = "串码（0不读取、1读取、2已读取）")
    private Integer bunchCodeFlag;

    @ApiModelProperty(name ="volume",value = "体积（立方米）")
    private BigDecimal volume;

    @ApiModelProperty(name ="weight",value = "重量（kg）")
    private BigDecimal weight;

    @ApiModelProperty(name ="rdcInfo",value = "RDC信息")
    private String rdcInfo;

    @ApiModelProperty(name ="onlineFlag",value = "是否线上（0否、1是）")
    private Integer onlineFlag;

    @ApiModelProperty(name ="deliveryWay",value = "发货方式（配送方式）")
    private String deliveryWay;

    @ApiModelProperty(name ="preDeliveryTime",value = "预计发货时间")
    private Date preDeliveryTime;

    @ApiModelProperty(name ="logisticsCompany",value = "承运商（物流公司）")
    private String logisticsCompany;

    @ApiModelProperty(name ="logisticsNo",value = "托运单号")
    private String logisticsNo;

    @ApiModelProperty(name ="sellerName",value = "发货方")
    private String sellerName;

    @ApiModelProperty(name ="saleChannel",value = "经销渠道")
    private String saleChannel;

    @ApiModelProperty(name ="customerCode",value = "客户编码")
    private String customerCode;


    @ApiModelProperty(name ="totalBoxNum",value = "总箱数")
    private BigDecimal totalBoxNum;

    @ApiModelProperty(name ="joinBoxNum",value = "拼箱数")
    private BigDecimal joinBoxNum;


    @ApiModelProperty(name ="preArriveTime",value = "预计达到时间")
    private Date preArriveTime;

    @ApiModelProperty(name ="interceptInfo",value = "拦截信息")
    private String interceptInfo;

    @ApiModelProperty(name ="pushOrderTime",value = "PCP推单时间")
    private Date pushOrderTime;

    @ApiModelProperty(name ="deliveryTime",value = "发货时间")
    private Date deliveryTime;

    @ApiModelProperty(name ="deliveryNoticeOrderNo",value = "发货通知单号")
    private String deliveryNoticeOrderNo;

    @ApiModelProperty(name ="deliveryNoticeOrderStatus",value = "发货通知单的状态")
    private String deliveryNoticeOrderStatus;

    @ApiModelProperty(name ="outNoticeOrderNo",value = "出库通知单号")
    private String outNoticeOrderNo;

    @ApiModelProperty(name ="outNoticeOrderStatus",value = "出库通知单的状态")
    private String outNoticeOrderStatus;

    @ApiModelProperty(name ="logicalWarehouseName",value = "逻辑仓名称")
    private String logicalWarehouseName;
}
