package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OrgRoleReqDto;
import com.dtyunxi.tcbj.api.dto.response.OrgRoleRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author jiejun
 * @date : 2022/02/22 10:25
 * @since 1.0.0
 */
@Api(tags = {"报表中心：查询组织角色列表"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/orgRole",
        url = "${tcbj.center.report.api:}"
)
public interface IOrgRoleQueryReportApi {

    /**
     * 查询组织角色分页列表
     *
     * @param orgRoleReqDto 查询参数
     */
    @PostMapping(value = {"/queryPage"}, produces = "application/json")
    @ApiOperation(value = "查询组织角色分页列表", notes = "查询组织角色分页列表")
    RestResponse<PageInfo<OrgRoleRespDto>> queryPage(@RequestBody OrgRoleReqDto orgRoleReqDto);
}
