package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OutNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.OutNoticeOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 出库通知单服务接口
*
* @author wude
* @since 2022-03-10
*/
@Api(tags = {"出库通知单服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/outNoticeOrder", url = "${tcbj.center.report.api:}")
public interface IOutNoticeOrderQueryApi {

    /**
    * 根据id查询出库通知单
    *
    * @param id 出库通知单id
    * @return   出库通知单数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询出库通知单", notes = "根据id查询出库通知单")
    RestResponse<OutNoticeOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 出库通知单分页数据
    *
    * @param filter   出库通知单查询条件
    * @return 出库通知单分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "出库通知单分页数据", notes = "根据filter查询条件查询出库通知单数据，filter=OutNoticeOrderReqDto")
    RestResponse<PageInfo<OutNoticeOrderRespDto>> queryByPage(@RequestBody OutNoticeOrderReqDto filter);

}
