package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryCountDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 逻辑仓库存表服务接口
*
* @author wude
* @since 2022-03-07
*/
@Api(tags = {"逻辑仓库存表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/logicInventory", url = "${tcbj.center.report.api:}")
public interface ILogicInventoryQueryApi {

    /**
    * 根据id查询逻辑仓库存表
    *
    * @param id 逻辑仓库存表id
    * @return   逻辑仓库存表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询逻辑仓库存表", notes = "根据id查询逻辑仓库存表")
    RestResponse<LogicInventoryRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 逻辑仓库存表分页数据
    *
    * @param filter   逻辑仓库存表查询条件
    * @return 逻辑仓库存表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "逻辑仓库存表分页数据", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<PageInfo<LogicInventoryRespDto>> queryByPage(@RequestBody LogicInventoryReqDto filter);

    /**
     * 逻辑仓库存统计数据
     *
     * @param filter   逻辑仓库存表查询条件
     * @return 逻辑仓库存表分页数据
     */
    @PostMapping("/count")
    @ApiOperation(value = "逻辑仓库存统计数据", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<LogicInventoryCountDto> queryByCount(@RequestBody LogicInventoryReqDto filter);

}
