/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.api.biz.promotion;

import com.dtyunxi.tcbj.api.biz.promotion.dto.CustomerInfo;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionActivityQueryDto;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionExportRow;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class PromotionExportService {
    @Resource
    private JdbcTemplate jdbcTemplate;

    public List<PromotionExportRow> exportByOrgId(PromotionActivityQueryDto req) {
        String orgId = req.getOrgId();
        String activityIds = (String)this.jdbcTemplate.queryForObject("SELECT GROUP_CONCAT(id) FROM mk_activity WHERE organization_id = ?", new Object[]{orgId}, String.class);
        if (activityIds == null || activityIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<PromotionExportRow> exportRows = this.callGenerateActivityExport(activityIds);
        HashMap<String, CustomerInfo> customerInfoMap = new HashMap<String, CustomerInfo>();
        for (String activityId : activityIds.split(",")) {
            CustomerInfo info = this.callGetCustomerInfo(activityId);
            if (info == null) continue;
            customerInfoMap.put(activityId, info);
        }
        for (PromotionExportRow row : exportRows) {
            CustomerInfo info = (CustomerInfo)customerInfoMap.get(row.getActivityCode());
            if (info != null) {
                row.setCustomerType(info.getCustomerType());
                row.setCustomerDetail(info.getCustomerDetail());
                continue;
            }
            row.setCustomerType("");
            row.setCustomerDetail("");
        }
        return exportRows;
    }

    private List<PromotionExportRow> callGenerateActivityExport(String activityIds) {
        return (List)this.jdbcTemplate.execute(con -> {
            CallableStatement cs = con.prepareCall("{CALL yx_prod_report.generate_activity_export(?)}");
            cs.setString(1, activityIds);
            return cs;
        }, cs -> {
            ArrayList<PromotionExportRow> list = new ArrayList<PromotionExportRow>();
            boolean hasResults = cs.execute();
            while (hasResults) {
                try (ResultSet rs = cs.getResultSet();){
                    while (rs.next()) {
                        PromotionExportRow row = new PromotionExportRow();
                        row.setIndex(rs.getInt("\u5e8f\u53f7"));
                        row.setDivision(rs.getString("\u4e8b\u4e1a\u90e8"));
                        row.setActivityCode(rs.getString("\u6d3b\u52a8\u7f16\u53f7"));
                        row.setActivityName(rs.getString("\u6d3b\u52a8\u540d\u79f0"));
                        row.setProductType(rs.getString("\u4ea7\u54c1\u7c7b\u578b"));
                        row.setProductCode(rs.getString("\u4ea7\u54c1\u7f16\u7801"));
                        row.setProductName(rs.getString("\u4ea7\u54c1\u540d\u79f0"));
                        row.setPrice(rs.getString("\u5efa\u8bae\u96f6\u552e\u4ef7"));
                        row.setExchangePrice(rs.getString("\u6362\u8d2d\u4ef7"));
                        row.setNotAloneBuy(rs.getString("\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70"));
                        row.setExchangeMethod(rs.getString("\u6362\u8d2d\u65b9\u5f0f"));
                        row.setQuotaType(rs.getString("\u989d\u5ea6\u7c7b\u578b"));
                        row.setRatio(rs.getString("\u6bd4\u4f8b"));
                        row.setCustomerType("");
                        row.setCustomerDetail("");
                        row.setActivityStartTime(rs.getString("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4"));
                        row.setActivityEndTime(rs.getString("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4"));
                        row.setActivityStatus(rs.getString("\u6d3b\u52a8\u72b6\u6001"));
                        list.add(row);
                    }
                }
                hasResults = cs.getMoreResults();
            }
            return list;
        });
    }

    private CustomerInfo callGetCustomerInfo(String activityId) {
        return (CustomerInfo)this.jdbcTemplate.execute(con -> {
            CallableStatement cs = con.prepareCall("{CALL yx_prod_report.proc_get_activity_customer_info_full(?)}");
            cs.setString(1, activityId);
            return cs;
        }, cs -> {
            CustomerInfo info = null;
            boolean hasResults = cs.execute();
            while (hasResults) {
                try (ResultSet rs = cs.getResultSet();){
                    if (rs.next()) {
                        info = new CustomerInfo();
                        info.setActivityId(activityId);
                        info.setCustomerType(rs.getString("customer_type"));
                        info.setCustomerDetail(rs.getString("customer_detail"));
                    }
                }
                hasResults = cs.getMoreResults();
            }
            return info;
        });
    }
}

