package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.BrotherCustomerShopRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;


@Api(tags = {"报表中心：药店查询接口"})
@FeignClient(
        name = "${com.dtyunxi.tcbj.api.name:tcbj-center-report}",
        path = "/v1/report/shop",
        url = "${tcbj.center.report.api:}"
)
public interface IShopReportQueryApi {

    /**
     * 根据当前客户id查询业务员可选择的兄弟客户店铺信息
     *
     * @return RestResponse<List < BrotherCustomerShopRespDto>>
     */
    @GetMapping("/queryBrotherCustomerShop")
    @ApiOperation(value = "根据当前客户id查询业务员可选择的兄弟客户店铺信息", notes = "根据当前客户id查询业务员可选择的兄弟客户店铺信息")
    RestResponse<List<BrotherCustomerShopRespDto>> queryBrotherCustomerShop();

}
