package com.dtyunxi.tcbj.api.biz.customer;

import com.dtyunxi.tcbj.api.biz.customer.dto.CustomerFullAreaDto;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaReq;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaResp;
import lombok.extern.log4j.Log4j2;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Log4j2
public class CustomerExport2025Service {

    @Resource
    private JdbcTemplate jdbcTemplate;

public QueryCustomerFullAreaResp queryCustomerFullArea(QueryCustomerFullAreaReq req) {
        log.info("查询客户完整区域信息，请求参数：{}", req);

        List<Long> customerIds = req.getCustomerIds();
        if (customerIds == null || customerIds.isEmpty()) {
            return QueryCustomerFullAreaResp.builder()
                    .customerFullAreaList(Collections.emptyList())
                    .build();
        }

        log.info("查询的客户ID列表：{}", customerIds);

        List<CustomerFullAreaDto> customerFullAreaList = queryCustomerFullAreaByIds(customerIds);

        log.info("查询完成，返回结果数量：{}", customerFullAreaList.size());

        return QueryCustomerFullAreaResp.builder()
                .customerFullAreaList(customerFullAreaList)
                .build();
    }

    /**
     * 根据客户ID列表查询完整区域信息
     */
    private List<CustomerFullAreaDto> queryCustomerFullAreaByIds(List<Long> customerIds) {
        String inSql = customerIds.stream()
                .map(String::valueOf)
                .collect(Collectors.joining(","));

        String sql = "SELECT customer_id AS customerId, " +
                     "full_area AS fullArea, " +
                     "t0.name AS region0, " +
                     "t1.name AS region1, " +
                     "t2.name AS region2 " +
                     "FROM yx_prod_customer.customer_full_area " +
                     "WHERE customer_id IN (" + inSql + ")";

        return jdbcTemplate.query(sql, (rs, rowNum) -> {
            CustomerFullAreaDto dto = new CustomerFullAreaDto();
            dto.setCustomerId(rs.getLong("customerId"));
            dto.setFullArea(rs.getString("fullArea"));
            dto.setRegion0(rs.getString("region0"));
            dto.setRegion1(rs.getString("region1"));
            dto.setRegion2(rs.getString("region2"));
            return dto;
        });
    }

}