package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.QueryItemOrgInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.QueryItemByBrandAndOrgReqDto;
import com.dtyunxi.tcbj.api.dto.response.QueryItemWithoutSuggestedPriceRespDto;
import com.dtyunxi.tcbj.api.dto.response.QueryItemByBrandAndOrgRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"报表中心：客户数据关联查询"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/itemInfo",
        url = "${tcbj.center.report.api:}"
)
public interface IItemInfoApi {

    @PostMapping(value = {"/queryItemWithoutSuggestedPrice"}, produces = "application/json")
    @ApiOperation(value = "查询没有建议零售价的item", notes = "查询没有建议零售价的item")
    RestResponse<List<QueryItemWithoutSuggestedPriceRespDto>> queryItemWithoutSuggestedPrice(@RequestBody QueryItemOrgInfoReqDto reqDto);


    @PostMapping(value = {"/queryItemByBrandAndOrg"}, produces = "application/json")
    @ApiOperation(value = "查询商品信息by 品牌code 品牌orgId")
    RestResponse<List<QueryItemByBrandAndOrgRespDto>> queryItemByBrandAndOrg(@RequestBody QueryItemByBrandAndOrgReqDto reqDto);
}
