package com.dtyunxi.tcbj.api.biz.customer;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaReq;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaResp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

// ----------------------------
// Feign Client接口
@Api(tags = "促销活动查询")
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/customer/export",
        url = "${tcbj.center.report.api:}"
)
public interface ICustomerExport2025Api {

    @PostMapping("/queryCustomerFullArea")
    @ApiOperation("查询客户区域列表")
    RestResponse<QueryCustomerFullAreaResp> queryCustomerFullArea(@RequestBody QueryCustomerFullAreaReq queryDto);
}






