package com.dtyunxi.tcbj.api.biz.promotion;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionActivityQueryDto;
import com.dtyunxi.tcbj.api.biz.promotion.dto.PromotionExportRow;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

// ----------------------------
// Feign Client接口
@Api(tags = "促销活动查询")
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/promotion",
        url = "${tcbj.center.report.api:}"
)
public interface IPromotionApi {

    @PostMapping("/queryActivity")
    @ApiOperation("查询促销活动列表")
    RestResponse<List<PromotionExportRow>> queryActivity(@RequestBody PromotionActivityQueryDto queryDto);
}






