/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.api.biz.customer;

import com.dtyunxi.tcbj.api.biz.customer.dto.CustomerFullAreaDto;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaReq;
import com.dtyunxi.tcbj.api.biz.customer.dto.QueryCustomerFullAreaResp;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class CustomerExport2025Service {
    private static final Logger log = LogManager.getLogger(CustomerExport2025Service.class);
    @Resource
    private JdbcTemplate jdbcTemplate;

    public QueryCustomerFullAreaResp queryCustomerFullArea(QueryCustomerFullAreaReq req) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u5b8c\u6574\u533a\u57df\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)req);
        List<Long> customerIds = req.getCustomerIds();
        if (customerIds == null || customerIds.isEmpty()) {
            return QueryCustomerFullAreaResp.builder().customerFullAreaList(Collections.emptyList()).build();
        }
        log.info("\u67e5\u8be2\u7684\u5ba2\u6237ID\u5217\u8868\uff1a{}", customerIds);
        List<CustomerFullAreaDto> customerFullAreaList = this.queryCustomerFullAreaByIds(customerIds);
        log.info("\u67e5\u8be2\u5b8c\u6210\uff0c\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\uff1a{}", (Object)customerFullAreaList.size());
        return QueryCustomerFullAreaResp.builder().customerFullAreaList(customerFullAreaList).build();
    }

    private List<CustomerFullAreaDto> queryCustomerFullAreaByIds(List<Long> customerIds) {
        String inSql = customerIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = "SELECT customer_id AS customerId, full_area AS fullArea, region0 AS region0, region1 AS region1, region2 AS region2 FROM customer_full_area WHERE customer_id IN (" + inSql + ")";
        return this.jdbcTemplate.query(sql, (rs, rowNum) -> {
            CustomerFullAreaDto dto = new CustomerFullAreaDto();
            dto.setCustomerId(rs.getLong("customerId"));
            dto.setFullArea(rs.getString("fullArea"));
            dto.setRegion0(rs.getString("region0"));
            dto.setRegion1(rs.getString("region1"));
            dto.setRegion2(rs.getString("region2"));
            return dto;
        });
    }
}

