/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.api.biz.inventory;

import com.dtyunxi.tcbj.api.biz.inventory.dto.ExternalSystemCodeDto;
import com.dtyunxi.tcbj.api.biz.inventory.dto.QueryExternalSystemCodeReq;
import com.dtyunxi.tcbj.api.biz.inventory.dto.QueryExternalSystemCodeResp;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class ItemQuery2025Service {
    private static final Logger log = LogManager.getLogger(ItemQuery2025Service.class);
    @Resource
    private JdbcTemplate jdbcTemplate;

    public QueryExternalSystemCodeResp queryItemExternalCode(QueryExternalSystemCodeReq req) {
        log.info("\u6839\u636e\u4ed3\u5e93\u7f16\u7801\u548cSAP\u5546\u54c1\u7f16\u7801\u67e5\u8be2\u5916\u56f4\u7cfb\u7edf\u7f16\u7801\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)req);
        String warehouseCode = req.getWarehouseCode();
        List<String> skuCodes = req.getSkuCodes();
        if (warehouseCode == null) {
            return QueryExternalSystemCodeResp.builder().externalSystemCodeList(Collections.emptyList()).build();
        }
        log.info("\u67e5\u8be2\u7684\u4ed3\u5e93\u7f16\u7801\uff1a{}\uff0cSAP\u5546\u54c1\u7f16\u7801\u5217\u8868\uff1a{}", (Object)warehouseCode, skuCodes);
        List<ExternalSystemCodeDto> externalSystemCodeList = this.queryExternalSystemCodeFromDatabase(warehouseCode, skuCodes);
        log.info("\u67e5\u8be2\u5b8c\u6210\uff0c\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\uff1a{}", (Object)externalSystemCodeList.size());
        return QueryExternalSystemCodeResp.builder().externalSystemCodeList(externalSystemCodeList).build();
    }

    private List<ExternalSystemCodeDto> queryExternalSystemCodeFromDatabase(String warehouseCode, List<String> skuCodes) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT auth.id AS authId, ").append("       shop.code AS tenantId, ").append("       shop.name AS tenantName, ").append("       warehouse.warehouse_code AS warehouseCode, ").append("       warehouse.warehouse_name AS warehouseName, ").append("       sku.code AS skuCode, ").append("       auth.external_code AS externalCode ").append("FROM it_item_auth auth ").append("INNER JOIN it_item_sku sku ON sku.id = auth.business_id AND sku.dr = 0 ").append("INNER JOIN sc_shop shop ON shop.id = auth.target_id AND target_type = '2' AND shop.dr = 0 ").append("INNER JOIN cs_logic_warehouse warehouse ON warehouse.organization_id = shop.organization_id AND warehouse.dr = 0 ").append("WHERE auth.dr = 0 ").append("  AND warehouse.warehouse_code = ? ");
        if (skuCodes != null && !skuCodes.isEmpty()) {
            String inSql = skuCodes.stream().map(skuCode -> "'" + skuCode + "'").collect(Collectors.joining(","));
            sqlBuilder.append("  AND sku.code IN (").append(inSql).append(")");
        }
        String sql = sqlBuilder.toString();
        return this.jdbcTemplate.query(sql, new Object[]{warehouseCode}, (rs, rowNum) -> {
            ExternalSystemCodeDto dto = new ExternalSystemCodeDto();
            dto.setAuthId(rs.getLong("authId"));
            dto.setTenantId(rs.getString("tenantId"));
            dto.setTenantName(rs.getString("tenantName"));
            dto.setWarehouseCode(rs.getString("warehouseCode"));
            dto.setWarehouseName(rs.getString("warehouseName"));
            dto.setSkuCode(rs.getString("skuCode"));
            dto.setExternalCode(rs.getString("externalCode"));
            return dto;
        });
    }
}

