package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.HomeStatisticsDeliverReqDto;
import com.dtyunxi.tcbj.api.dto.response.HomeStatisticsDeliverRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"报表中心：首页统计"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IHomeStatisticsReportApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/homeStatisticsReport",
        url = "${tcbj.center.report.api:}"
)
public interface IHomeStatisticsReportApi {

    /**
     * 已发货情况统计
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/queryDeliverStatistics")
    @ApiOperation(value = "已发货情况统计", notes = "已发货情况统计")
    RestResponse<List<HomeStatisticsDeliverRespDto>> queryDeliverStatistics(@RequestBody HomeStatisticsDeliverReqDto reqDto);

    /**
     * 未发货情况统计
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/queryNotDeliverStatistics")
    @ApiOperation(value = "未发货情况统计", notes = "未发货情况统计")
    RestResponse<List<HomeStatisticsDeliverRespDto>> queryNotDeliverStatistics(@RequestBody HomeStatisticsDeliverReqDto reqDto);
}
