package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 活动明细
 * @since 2022-01-19 16:44
 */
@Data
@ApiModel(value = "OrderActivityDetailRespDto", description = "活动明细")
public class OrderActivityDetailRespDto {

    @ApiModelProperty(name = "activityCode", value = "活动编码")
    private String activityCode;

    @ApiModelProperty(name = "activityName", value = "活动名称")
    private String activityName;

    @ApiModelProperty(name = "shopName", value = "所属公司(店铺)")
    private String shopName;

    @ApiModelProperty(name = "preheatStartTime", value = "预热开始")
    private String preheatStartTime;

    @ApiModelProperty(name = "beginTime", value = "活动开始")
    private String beginTime;

    @ApiModelProperty(name = "endTime", value = "活动结束")
    private String endTime;

    @ApiModelProperty(name = "activityStatus", value = "活动状态: NEW:新建, READY:就绪, DISABLE:禁用," +
            " ACTIVATE:活动中, PAUSE:暂停, FINISHING:结束中, FINISH: 活动结束, ERROR_FINISH: 异常结束")
    private String activityStatus;

    private String activityStatusStr;

    @ApiModelProperty(name = "customerName", value = "参与客户")
    private String customerName;

    @ApiModelProperty(name = "discountAmount", value = "优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty(name = "orderNo", value = "关联单号")
    private String orderNo;

    @ApiModelProperty(name = "type", value = "活动类型： 1 拼团活动 2 优惠券活动 3 秒杀活动 4 促销活动(包括满赠满减满折) 5 积分抵扣活动 6 限时特价活动")
    private String type;

    private String typeStr;

    @ApiModelProperty(name = "customerCode", value = "活动编码")
    private String customerCode;

    private Long shopId;
}
