package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import liquibase.pro.packaged.S;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 订单明细统计base
 * @since 2022-01-18 10:35
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrderDetailBaseRespDto extends ReportBaseRespDto {

    @ApiModelProperty(name = "companyName", value = "所属公司(店铺对应的名称)")
    private String companyName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemType", value = "商品类型")
    private Integer itemType;

    @ApiModelProperty(name = "itemTypeStr", value = "商品类型名称")
    private String itemTypeStr;

    @ApiModelProperty(name = "skuDesc", value = "商品规格")
    private String skuDesc;

    @ApiModelProperty(name = "salePrice", value = "销售单价")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "promotionSalePrice", value = "促销单价")
    private BigDecimal promotionSalePrice;

    @ApiModelProperty(name = "eachActivityShareAmount", value = "每件活动分摊总额")
    private BigDecimal eachActivityShareAmount;

    @ApiModelProperty(name = "eachDiscountDeductionAmount", value = "每件折扣抵扣金额")
    private BigDecimal eachDiscountDeductionAmount;

    @ApiModelProperty(name = "eachGiftBalanceDiscountAmount", value = "每件赠送额度抵扣金额")
    private BigDecimal eachGiftBalanceDiscountAmount;

    @ApiModelProperty(name = "activityShareAmount", value = "活动分摊总额")
    private BigDecimal activityShareAmount;

    @ApiModelProperty(name = "discountDeductionAmount", value = "折扣抵扣金额")
    private BigDecimal discountDeductionAmount;

    @ApiModelProperty(name = "giftBalanceDiscountAmount", value = "赠送额度抵扣金额")
    private BigDecimal giftBalanceDiscountAmount;

    @ApiModelProperty(name = "itemPrice", value = "实卖单价")
    private BigDecimal itemPrice;

    @ApiModelProperty(name = "salesmanName", value = "业务员（小b客户对应的业务员）")
    private String salesmanName;

    @ApiModelProperty(name = "batchNo", value = "批次")
    private String batchNo;

//    @ApiModelProperty(name = "customerCode", value = "客户编码")
//    private String customerCode;

    private Long shopId;
}
