package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 销售结果单Dto
 */
@Data
public class SaleResultOrderRespDto {

    private String documentNo;

    private String businessType;

    private String orderType;

    private Date createTime;

    @ApiModelProperty(name = "organizationCode",value = "库存组织编号")
    private String organizationCode;

    @ApiModelProperty(name = "saleOrganizationCode",value = "销售组织编号")
    private String saleOrganizationCode;

    @ApiModelProperty(name = "saleOrganizationName",value = "销售组织名称")
    private String saleOrganizationName;

    private String customerCode;

    private String preOrderNo;

    private String relevanceNo;

    private String platformOrderNo;

    private String platformParentOrderNo;

    private String externalOrderNo;

    private String remark;

    private String easSaleOrderNo;

    private String extension;

    @ApiModelProperty(name = "receiveName",value = "收获人")
    private String receiveName;

    @ApiModelProperty(name = "receivePhone",value = "收货人手机号码")
    private String receivePhone;

    @ApiModelProperty(name = "receiveAddress",value = "收货地址")
    private String receiveAddress;

    @ApiModelProperty(name = "shippingCode",value = "托运单号")
    private String shippingCode;

    @ApiModelProperty(name = "tenantId",value = "租户ID")
    private String tenantId;

    @ApiModelProperty(name = "secondTenantId",value = "二级租户ID")
    private String secondTenantId;

    @ApiModelProperty(name = "thirdCustomerId",value = "外部客户ID")
    private String thirdCustomerId;

    @ApiModelProperty(name = "mainOrderNo",value = "主单号")
    private String mainOrderNo;

    @ApiModelProperty(name = "dealerId",value = "进销商ID")
    private String dealerId;

    @ApiModelProperty(name = "providerId",value = "供应商ID")
    private String providerId;

    @ApiModelProperty(name = "saleType",value = "销售类型")
    private String saleType;

    @ApiModelProperty(name = "sourceOrderNo",value = "源头单号")
    private String sourceOrderNo;

    @ApiModelProperty(name = "sourceParentOrderNo",value = "源头父单号")
    private String sourceParentOrderNo;

    @ApiModelProperty(name = "itemTotalAmount",value = "商品总金额")
    private String itemTotalAmount;

    @ApiModelProperty(name = "shippingJson",value = "物流JSON")
    private String shippingJson;

    private List<SaleResultOrderDetailRespDto> details = new ArrayList<>();
}
