package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import liquibase.pro.packaged.S;

import java.math.BigDecimal;
import lombok.Data;

/**
* 库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录Eo对象
*
* @author wude
* @since 2022-03-11
*/
@Data
@ApiModel(value = "InventoryOperateLogRespDto", description = "库存操作流水表，如果一次库存操作中变动了N个库存字段，则会存入N条对应记录Eo对象")
public class InventoryOperateLogRespDto extends ResponseDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  版本号
    */
    @ApiModelProperty(name = "version", value = "版本号")
    private String version;
    /**
    *  仓库ID
    */
    @ApiModelProperty(name = "warehouseId", value = "仓库ID")
    private Long warehouseId;
    /**
    *  仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;
    /**
    *  仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    private String warehouseName;
    /**
    *  仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓
    */
    @ApiModelProperty(name = "warehouseClassify", value = "仓库分类:physics-物理仓,logic-逻辑仓,virtual-虚拟仓,channel-渠道仓")
    private String warehouseClassify;
    /**
    *  仓库对应于不同层级仓库的类型
    */
    @ApiModelProperty(name = "warehouseType", value = "仓库对应于不同层级仓库的类型")
    private String warehouseType;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  批次类型 common-正常,defective-残次品,其他类型待定
    */
    @ApiModelProperty(name = "batchType", value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /**
    *  单据类型,待定
    */
    @ApiModelProperty(name = "sourceType", value = "单据类型,待定")
    private String sourceType;
    /**
    *  来源单据号
    */
    @ApiModelProperty(name = "sourceNo", value = "来源单据号")
    private String sourceNo;

    /**
     *  外部单号
     */
    @ApiModelProperty(name = "externalOrderNo", value = "外部单号")
    private String externalOrderNo;
    /**
    *  变动前库存
    */
    @ApiModelProperty(name = "beforeInventory", value = "变动前库存")
    private BigDecimal beforeInventory;
    /**
    *  变动库存
    */
    @ApiModelProperty(name = "changeInventory", value = "变动库存")
    private BigDecimal changeInventory;
    /**
    *  变动后库存
    */
    @ApiModelProperty(name = "afterInventory", value = "变动后库存")
    private BigDecimal afterInventory;
    /**
    *  变动类型
    */
    @ApiModelProperty(name = "changeType", value = "变动类型")
    private String changeType;
    /**
    *  出入库标识  in-入库  out-出库
    */
    @ApiModelProperty(name = "inOutFlag", value = "出入库标识  in-入库  out-出库")
    private String inOutFlag;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  变动时间
    */
    @ApiModelProperty(name = "changeTime", value = "变动时间")
    private Date changeTime;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    
    /**
     *  业务类型
     */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
}
