package com.dtyunxi.tcbj.api.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @author fengzr
 * @date 2023-11-14 15:10
 **/
@Data
@ApiModel(value = "InTransitInNoticeDetailVo", description = "在途库存交易查询返回对象")
public class InTransitInNoticeDetailVo {

    @ApiModelProperty(name = "inNoticeNo", value = "入库通知单号")
    private String inNoticeNo;

    @ApiModelProperty(name = "transferOrderNo", value = "调拨单号")
    private String transferOrderNo;

    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "调出物理仓编码")
    private String outPhysicsWarehouseCode;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "调出物理仓名称")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "inLogicWarehouseCode", value = "入库逻辑仓编码")
    private String inLogicWarehouseCode;

    @ApiModelProperty(name = "inLogicWarehouseName", value = "入库逻辑仓名称")
    private String inLogicWarehouseName;

    @ApiModelProperty(name = "inTransitLogicWarehouseCode", value = "在途逻辑仓编码")
    private String inTransitLogicWarehouseCode;

    @ApiModelProperty(name = "inTransitLogicWarehouseName", value = "在途逻辑仓名称")
    private String inTransitLogicWarehouseName;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    @ApiModelProperty(name = "skuName", value = "sku名称")
    private String skuName;

    @ApiModelProperty(name = "quantity", value = "数量")
    private Long quantity;

    @ApiModelProperty(name = "batches", value = "批次信息")
    private List<Batch> batches;

    @ApiModelProperty(name = "wmsConsignmentNo", value = "运单号")
    private String wmsConsignmentNo;

    @ApiModelProperty(name = "carrierName", value = "承运商")
    private String carrierName;

    @ApiModelProperty(name = "carrierType", value = "承运方式")
    private String carrierType;

    @ApiModelProperty(name = "deliveryTime", value = "发货时间")
    private LocalDateTime deliveryTime;

    @ApiModelProperty(name = "planArriveDays", value = "预计到达天数")
    private Integer planArriveDays;

    @ApiModelProperty(name = "planArriveTime", value = "预计到达时间")
    private LocalDateTime planArriveTime;

}
