package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 经销商报表-产品排名respDto
 * @since 2022-01-06 10:06
 */
@Data
@ApiModel(value = "OrderItemProductRankingRespDto", description = "经销商报表-产品排名respDto")
public class OrderItemProductRankingRespDto {

    @ApiModelProperty(name = "customerAreaName", value = "产品排名")
    private Integer productRanking;

    @ApiModelProperty(name = "customerName", value = "产品编码")
    private String productCode;

    @ApiModelProperty(name = "productName", value = "产品名称")
    private String productName;

    @ApiModelProperty(name = "orderNum", value = "数量")
    private Integer orderNum;

    @ApiModelProperty(name = "orderPayAmount", value = "金额")
    private BigDecimal orderPayAmount;

    @ApiModelProperty(name = "orderNumOfLastYear", value = "去年同期数量")
    private Integer orderNumOfLastYear;

    @ApiModelProperty(name = "orderPayAmountOfLastYear", value = "去年同期金额")
    private BigDecimal orderPayAmountOfLastYear;

    @ApiModelProperty(name = "rateOfRise", value = "增长率")
    private BigDecimal rateOfRise;

}
