package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.tcbj.api.dto.request.InventoryCheckItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import liquibase.pro.packaged.F;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @author jack
 * @version 1.0
 * @date 02/09/2022 19:17
 **/
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "InventoryCheckRespDto", description = "库存校验对象")
public class InventoryCheckRespDto {

    @ApiModelProperty(name = "checkType", value = "1. 校验渠道仓供货仓库存 2. 校验逻辑仓")
    private boolean checkResult = false;

    @ApiModelProperty(name = "items", value = "校验类型")
    private List<InventoryCheckItem> items;

}
