package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DailyDeliveryFeeFilterExtConfigReqDto;
import com.dtyunxi.tcbj.api.dto.response.DailyDeliveryFeeFilterExtConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

@Api(tags = {"剔除计费扩张配置服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IDailyDeliveryFeeFilterExtConfigApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/dailyDeliveryFeeFilterExtConfig",
        url = "${tcbj.center.report.api:}"
)
public interface IDailyDeliveryFeeFilterExtConfigApi {

    @PostMapping("/addDailyDeliveryFeeFilterExtConfig")
    @ApiOperation(value = "新增剔除计费扩张配置", notes = "新增剔除计费扩张配置")
    RestResponse<Long> addDailyDeliveryFeeFilterExtConfig(@RequestBody DailyDeliveryFeeFilterExtConfigReqDto addReqDto);

    @PutMapping("/modifyDailyDeliveryFeeFilterExtConfig")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> modifyDailyDeliveryFeeFilterExtConfig(@RequestBody DailyDeliveryFeeFilterExtConfigReqDto modifyReqDto);

    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> removeDailyDeliveryFeeFilterExtConfig(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
