/**
 * @(#) OtherOutVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.util.List;

/**
 * OtherOutVO
 */
@Data
@ApiModel(value = "OtherOutVO", description = "")
public class OtherOutVO {
  
  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private String createTime = null;
  
  
  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  private String updateTime = null;
  
  
  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson = null;
  
  
  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson = null;
  
  
  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id = null;
  
  
  @ApiModelProperty(name="bussinessOrderNo", value = "其他入库单号")
  @JsonProperty("bussinessOrderNo")
  private String bussinessOrderNo = null;
  
  
  @ApiModelProperty(name="bussinessOrderType", value = "业务类型")
  @JsonProperty("bussinessOrderType")
  private String bussinessOrderType;


  @ApiModelProperty(name="bussinessOrderTypeName", value = "业务类型")
  @JsonProperty("bussinessOrderTypeName")
  private String bussinessOrderTypeName;
  
  
  @ApiModelProperty(name="bussinessOrderStatus", value = "单据状态")
  @JsonProperty("bussinessOrderStatus")
  private String bussinessOrderStatus = null;
  
  
  @Valid 
  @ApiModelProperty(name="logicalWarehouse", value = "")
  @JsonProperty("logicalWarehouse")
  private LogicalWarehouseVO logicalWarehouse;

  @ApiModelProperty(name="cargoRightId", value = "货权组织ID")
  @JsonProperty("cargoRightId")
  private String cargoRightId;


  @ApiModelProperty(name="cargoRightName", value = "货权组织名称")
  @JsonProperty("cargoRightName")
  private String cargoRightName;
  
  
  @ApiModelProperty(name="customerName", value = "客户名称")
  @JsonProperty("customerName")
  private String customerName;
  
  
  @ApiModelProperty(name="customerCode", value = "客户编号")
  @JsonProperty("customerCode")
  private String customerCode;
  
  
  @ApiModelProperty(name="customerId", value = "客户ID")
  @JsonProperty("customerId")
  private String customerId;
  
  
  @ApiModelProperty(name="consigneeName", value = "收货人姓名")
  @JsonProperty("consigneeName")
  private String consigneeName;
  
  
  @ApiModelProperty(name="consigneePhone", value = "收货人电话")
  @JsonProperty("consigneePhone")
  private String consigneePhone;
  
  
  @Valid 
  @ApiModelProperty(name="consigneeAddress", value = "")
  @JsonProperty("consigneeAddress")
  private AddressVO consigneeAddress;
  
  
  @ApiModelProperty(name="summary", value = "摘要")
  @JsonProperty("summary")
  private String summary;
  
  
  @ApiModelProperty(name="remark", value = "备注")
  @JsonProperty("remark")
  private String remark;
  
  
  @Valid 
  @ApiModelProperty(name="associatedDocumentList", value = "关联单据")
  @JsonProperty("associatedDocumentList")
  private List<AssociatedDocumentVO> associatedDocumentList = null;
  
  
  @Valid 
  @ApiModelProperty(name="auditRecordList", value = "审核信息")
  @JsonProperty("auditRecordList")
  private List<AuditVO> auditRecordList = null;


  @ApiModelProperty(name="externalOrderNo", value = "外部单号")
  @JsonProperty("externalOrderNo")
  private String externalOrderNo = null;


  @ApiModelProperty(name="relationBussinessOrderNo", value = "关键业务单号")
  @JsonProperty("relationBussinessOrderNo")
  private String relationBussinessOrderNo = null;


  @ApiModelProperty(name="isOAAudit", value = "是否OA审核")
  @JsonProperty("isOAAudit")
  private String isOAAudit = null;

    @ApiModelProperty(name="costCenterCode", value = "成本中心编码")
    private String costCenterCode;
    @ApiModelProperty(name="costCenterName", value = "成本中心名称")
    private String costCenterName;
  
}

