package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
* 仓储费用分摊记录表Eo对象
*
* @author by_liusong
* @since 2022-08-26
*/
public class StorageLogicInventoryRespDto extends CubeBaseEo{
    /**
    *  统计数据月份
    */
    @Column(name = "record_month")
    private Date recordMonth;
    /**
    *  物理仓库编码
    */
    @Column(name = "physics_warehouse_code")
    private String physicsWarehouseCode;
    /**
    *  物理仓库名称
    */
    @Column(name = "physics_warehouse_name")
    private String physicsWarehouseName;
    /**
    *  逻辑仓库编码
    */
    @Column(name = "logic_warehouse_code")
    private String logicWarehouseCode;
    /**
    *  逻辑仓库名称
    */
    @Column(name = "logic_warehouse_name")
    private String logicWarehouseName;
    /**
    *  商品长编码
    */
    @Column(name = "op_long_code")
    private String opLongCode;
    /**
    *  商品名称
    */
    @Column(name = "item_name")
    private String itemName;
    /**
    *  批次
    */
    @Column(name = "batch")
    private String batch;
    /**
     *  批次
     */
    @Column(name = "volume")
    private BigDecimal volume;
    /**
    *  即时库存数
    */
    @Column(name = "inventory_num")
    private Integer inventoryNum;

    /**
     *  单据入库数据
     */
    private Integer quantity;

    /**
    *  大包系数   => 变更取值   big_box
    */
    @Column(name = "big_ratio")
    private Integer bigRatio;
    /**
    *  托码数
    */
    @Column(name = "zh_tray_num")
    private Integer zhTrayNum;
    /**
    *  板数
    */
    @Column(name = "support")
    private Integer support;
    /**
    *  入库时间
    */
    @Column(name = "in_delivery_time")
    private Date inDeliveryTime;
    /**
    *  货权归属组织id
    */
    @Column(name = "belong_org_id")
    private Long belongOrgId;
    /**
    *  货权所属组织名称
    */
    @Column(name = "belong_org_name")
    private String belongOrgName;
    /**
     *  是否生成分摊数据
     */
    @Column(name = "is_apportion")
    private Integer isApportion;
    /**
    *  组织id
    */
    @Column(name = "org_id")
    private Long orgId;

    public void setRecordMonth(Date recordMonth){
    this.recordMonth = recordMonth;
    }
    public Date getRecordMonth(){
    return this.recordMonth;
    }
    public void setPhysicsWarehouseCode(String physicsWarehouseCode){
    this.physicsWarehouseCode = physicsWarehouseCode;
    }
    public String getPhysicsWarehouseCode(){
    return this.physicsWarehouseCode;
    }
    public void setPhysicsWarehouseName(String physicsWarehouseName){
    this.physicsWarehouseName = physicsWarehouseName;
    }
    public String getPhysicsWarehouseName(){
    return this.physicsWarehouseName;
    }
    public void setLogicWarehouseCode(String logicWarehouseCode){
    this.logicWarehouseCode = logicWarehouseCode;
    }
    public String getLogicWarehouseCode(){
    return this.logicWarehouseCode;
    }
    public void setLogicWarehouseName(String logicWarehouseName){
    this.logicWarehouseName = logicWarehouseName;
    }
    public String getLogicWarehouseName(){
    return this.logicWarehouseName;
    }
    public void setOpLongCode(String opLongCode){
    this.opLongCode = opLongCode;
    }
    public String getOpLongCode(){
    return this.opLongCode;
    }
    public void setItemName(String itemName){
    this.itemName = itemName;
    }
    public String getItemName(){
    return this.itemName;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public void setInventoryNum(Integer inventoryNum){
    this.inventoryNum = inventoryNum;
    }
    public Integer getInventoryNum(){
    return this.inventoryNum;
    }
    public void setBigRatio(Integer bigRatio){
    this.bigRatio = bigRatio;
    }
    public Integer getBigRatio(){
    return this.bigRatio;
    }
    public void setZhTrayNum(Integer zhTrayNum){
    this.zhTrayNum = zhTrayNum;
    }
    public Integer getZhTrayNum(){
    return this.zhTrayNum;
    }
    public void setSupport(Integer support){
    this.support = support;
    }
    public Integer getSupport(){
    return this.support;
    }
    public void setInDeliveryTime(Date inDeliveryTime){
    this.inDeliveryTime = inDeliveryTime;
    }
    public Date getInDeliveryTime(){
    return this.inDeliveryTime;
    }
    public void setBelongOrgId(Long belongOrgId){
    this.belongOrgId = belongOrgId;
    }
    public Long getBelongOrgId(){
    return this.belongOrgId;
    }
    public void setBelongOrgName(String belongOrgName){
    this.belongOrgName = belongOrgName;
    }
    public String getBelongOrgName(){
    return this.belongOrgName;
    }

    public Integer getIsApportion() {
        return isApportion;
    }

    public void setIsApportion(Integer isApportion) {
        this.isApportion = isApportion;
    }

    public void setOrgId(Long orgId){
    this.orgId = orgId;
    }
    public Long getOrgId(){
    return this.orgId;
    }
}
