package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "SaleIntransitEarlyWarningReportRespDto", description = "销售在途预警报表")
public class SaleIntransitEarlyWarningReportRespDto {

    @ApiModelProperty(name ="platformOrderId",value = "平台订单id")
    private Long platformOrderId;
    @ApiModelProperty(name ="platformOrderNo",value = "平台订单号")
    private String platformOrderNo;

    @ApiModelProperty(name ="saleOrderNo",value = "内部销售订单号")
    private String saleOrderNo;

    @ApiModelProperty(name = "easOrderNo",value = "eas单号")
    private String easOrderNo;

    @ApiModelProperty(name ="orderLevel",value = "订单级别（0原、1主、2子）")
    private Integer orderLevel;

    @ApiModelProperty(name ="orderType",value = "订单类型 ")
    private String orderType;

    @ApiModelProperty(name = "orderStatus", value = "订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分")
    private String orderStatus;

    @ApiModelProperty(name = "secondOrderStatus", value = "订单子状态 WAIT_PICK_UNLOCK-待配货未锁定  WAIT_PICK_LOCK_UN_APPOINT-已锁定待指派PART_OUT_DELIVERY-部分出库 ALL_OUT_DELIVERY-全部出库")
    private String secondOrderStatus;


    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    @ApiModelProperty(name ="goodsTotalNum",value = "明细数量汇总（商品总数量）")
    private BigDecimal goodsTotalNum;

    @ApiModelProperty(name ="lessNum",value = "缺货数量（在途数量）")
    private BigDecimal lessNum;

    @ApiModelProperty(name ="planArriveTime",value = "计划达到时间")
    private Date planArriveTime;

    @ApiModelProperty(name = "outTime", value = "出库时间")
    private Date outTime;


    @ApiModelProperty(name = "refCarLicenseNo", value = "关联的车牌信息")
    private String refCarLicenseNo;


    @ApiModelProperty(name = "refTransferOrderNo", value = "关联的调拨单号")
    private String refTransferOrderNo;

    @ApiModelProperty(name="logicalWarehouseName", value = "逻辑仓名称")
    private String logicalWarehouseName;

    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;

    @ApiModelProperty( name = "allowSplitFlag",value = "是否接受拆单 0-否 1-是")
    private Integer allowSplitFlag;

    @ApiModelProperty(name ="customerName",value = "客户名称")
    private String customerName;

    @ApiModelProperty(name ="receiveName",value = "收件人姓名")
    private String receiveName;

    @ApiModelProperty(name ="receivePhone",value = "收件人电话")
    private String receivePhone;

    @ApiModelProperty(name = "receiveAddress", value = "地址、区域实体")
    private String receiveAddress;



    @ApiModelProperty(name ="platformCreateTime",value = "平台创建时间/下单时间")
    private Date platformCreateTime;

    @ApiModelProperty(name ="saleCreateTime",value = "内部销售订单创建时间")
    private Date saleCreateTime;

    @ApiModelProperty( name = "isTagFlag",value = "是否打标 0-否 1-是")
    private Integer isTagFlag;

    @ApiModelProperty( name = "isRedFlag",value = "是否描红 0-否 1-是")
    private Integer isRedFlag;


}
