package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* 发/收货结果单明细Eo对象
*
* @author by_liusong
* @since 2022-08-02
*/
@ApiModel(value = "DeliveryResultOrderDetailRespDto", description = "发/收货结果单明细Eo对象")
public class DeliveryResultOrderDetailRespDto extends BaseRespDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  发/收货结果单号
    */
    @ApiModelProperty(name = "documentNo", value = "发/收货结果单号")
    private String documentNo;
    /**
    *  关联单据号
    */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
    *  前置单号,为出库结果单号
    */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号,为出库结果单号")
    private String preOrderNo;
    /**
    *  第三方单据号
    */
    @ApiModelProperty(name = "externalOrderNo", value = "第三方单据号")
    private String externalOrderNo;
    /**
    *  wms单号
    */
    @ApiModelProperty(name = "wmsOrderNo", value = "wms单号")
    private String wmsOrderNo;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    //弃用
//    /**
//    *  商品长编码
//    */
//    @ApiModelProperty(name = "longCode", value = "商品长编码")
//    private String longCode;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  原始计划发/收货数量
    */
    @ApiModelProperty(name = "originPlanQuantity", value = "原始计划发/收货数量")
    private BigDecimal originPlanQuantity;
    /**
    *  计划发/收货数量
    */
    @ApiModelProperty(name = "planQuantity", value = "计划发/收货数量")
    private BigDecimal planQuantity;
    /**
    *  待发/收货数量
    */
    @ApiModelProperty(name = "waitQuantity", value = "待发/收货数量")
    private BigDecimal waitQuantity;
    /**
    *  已发/收货数量
    */
    @ApiModelProperty(name = "doneQuantity", value = "已发/收货数量")
    private BigDecimal doneQuantity;
    /**
    *  已取消数量
    */
    @ApiModelProperty(name = "cancelQuantity", value = "已取消数量")
    private BigDecimal cancelQuantity;
    /**
    *  真实发/收货数量
    */
    @ApiModelProperty(name = "quantity", value = "真实发/收货数量")
    private BigDecimal quantity;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  活动ID,只有是活动类型的商品才有值
    */
    @ApiModelProperty(name = "activityId", value = "活动ID,只有是活动类型的商品才有值")
    private Long activityId;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;

    @ApiModelProperty(name = "skuCode", value = "skuCode")
    private String skuCode;

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setDocumentNo(String documentNo){
    this.documentNo = documentNo;
    }
    public String getDocumentNo(){
    return this.documentNo;
    }
    public void setRelevanceNo(String relevanceNo){
    this.relevanceNo = relevanceNo;
    }
    public String getRelevanceNo(){
    return this.relevanceNo;
    }
    public void setPreOrderNo(String preOrderNo){
    this.preOrderNo = preOrderNo;
    }
    public String getPreOrderNo(){
    return this.preOrderNo;
    }
    public void setExternalOrderNo(String externalOrderNo){
    this.externalOrderNo = externalOrderNo;
    }
    public String getExternalOrderNo(){
    return this.externalOrderNo;
    }
    public void setWmsOrderNo(String wmsOrderNo){
    this.wmsOrderNo = wmsOrderNo;
    }
    public String getWmsOrderNo(){
    return this.wmsOrderNo;
    }
    public void setCargoId(Long cargoId){
    this.cargoId = cargoId;
    }
    public Long getCargoId(){
    return this.cargoId;
    }
    public void setCargoCode(String cargoCode){
    this.cargoCode = cargoCode;
    }
    public String getCargoCode(){
    return this.cargoCode;
    }
    public void setCargoName(String cargoName){
    this.cargoName = cargoName;
    }
    public String getCargoName(){
    return this.cargoName;
    }
    public void setArtNo(String artNo){
    this.artNo = artNo;
    }
    public String getArtNo(){
    return this.artNo;
    }
    public void setBatch(String batch){
    this.batch = batch;
    }
    public String getBatch(){
    return this.batch;
    }
    public void setOriginPlanQuantity(BigDecimal originPlanQuantity){
    this.originPlanQuantity = originPlanQuantity;
    }
    public BigDecimal getOriginPlanQuantity(){
    return this.originPlanQuantity;
    }
    public void setPlanQuantity(BigDecimal planQuantity){
    this.planQuantity = planQuantity;
    }
    public BigDecimal getPlanQuantity(){
    return this.planQuantity;
    }
    public void setWaitQuantity(BigDecimal waitQuantity){
    this.waitQuantity = waitQuantity;
    }
    public BigDecimal getWaitQuantity(){
    return this.waitQuantity;
    }
    public void setDoneQuantity(BigDecimal doneQuantity){
    this.doneQuantity = doneQuantity;
    }
    public BigDecimal getDoneQuantity(){
    return this.doneQuantity;
    }
    public void setCancelQuantity(BigDecimal cancelQuantity){
    this.cancelQuantity = cancelQuantity;
    }
    public BigDecimal getCancelQuantity(){
    return this.cancelQuantity;
    }
    public void setQuantity(BigDecimal quantity){
    this.quantity = quantity;
    }
    public BigDecimal getQuantity(){
    return this.quantity;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setActivityId(Long activityId){
    this.activityId = activityId;
    }
    public Long getActivityId(){
    return this.activityId;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
}
