package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 销售结果单明细
 */
@Data
public class SaleOrderResultOfFinanceDetailRespDto {
    //private Long id;

    private String type;

    private String orderNo;

    private Long detailItemId;

    private String documentNo;

    private String platformOrderNo;

    @ApiModelProperty(name = "cargoCode",value = "货品编码，短编码")
    private String cargoCode;

    @ApiModelProperty(name = "longCode",value = "货品编码，长编码")
    private String longCode;

    @ApiModelProperty(name = "cargoName",value = "货品名称")
    private String cargoName;

    @ApiModelProperty(name = "batch",value = "批次")
    private String batch;

    @ApiModelProperty(name = "produceTime",value = "生产日期")
    private Date produceTime;

    @ApiModelProperty(name = "expireTime",value = "过期日期")
    private Date expireTime;

    @ApiModelProperty(name = "quantity",value = "数量")
    private Integer quantity;

    @ApiModelProperty(name = "taxPrice",value = "零售产品单价（含税）")
    private BigDecimal taxPrice;

    @ApiModelProperty(name = "salePrice",value = "供货单价（含税）")
    private BigDecimal salePrice;

    @ApiModelProperty(name = "actuallyAmount",value = "明细实付总额（含税）")
    private BigDecimal actuallyAmount;

    @ApiModelProperty(name = "payableAmount",value = "明细应付总额（含税）")
    private BigDecimal payableAmount;

    @ApiModelProperty(name = "payableAmountSingle",value = "明细应付总额（含税）单价")
    private BigDecimal payableAmountSingle;

    @ApiModelProperty(name = "discountAmount",value = "折扣额")
    private BigDecimal discountAmount;

    @ApiModelProperty(name = "discountAmountSingle",value = "折扣额单价")
    private BigDecimal discountAmountSingle;

    @ApiModelProperty(name = "taxRate",value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "销售单出仓/销售红单入仓")
    private String warehouseCode;

    @ApiModelProperty(value = "源明细ID")
    private String sourceBillEntryId;

    @ApiModelProperty(value = "是否赠品")
    private Integer ifGift;

    @ApiModelProperty(value = "是否积分产品")
    private Integer ifIntegral;

    @ApiModelProperty(value = "使用积分")
    private BigDecimal totalScore;

    private BigDecimal totalScoreSingle;

    @ApiModelProperty(name = "transactionPrice",value = "实收成本单价")
    private BigDecimal transactionPrice;

    private String extension;

    private Integer retryCount;

    @ApiModelProperty(name="projectNo",value = "项目编号")
    private String projectNo;

    @ApiModelProperty(name="ifOnline",value = "是否线上")
    private Integer ifOnline;

    @ApiModelProperty(name="trackPlan",value = "跟踪计划")
    private String trackPlan;

    @ApiModelProperty(name = "myBeforeDisAmt", value = "折前价税合计")
    private BigDecimal myBeforeDisAmt;

    @ApiModelProperty(name = "myPromotionDis", value = "促销活动折扣")
    private BigDecimal myPromotionDis;

    @ApiModelProperty(name = "mySaleReturnDis", value = "销售返利折扣")
    private BigDecimal mySaleReturnDis;

    @ApiModelProperty(value = "CSP行号")
    private String cspLineNo;

    @ApiModelProperty(value = "SAP行号")
    private String sapLineNo;
    @ApiModelProperty(value = "业务类型")
    private String orderType;
    @ApiModelProperty(value = "sap单号")
    private String sapOrderNo;
}
