package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportQueryDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportQueryListDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticsReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 物流运费合计记录表服务接口
*
* @author author
* @since 2022-07-17
*/
@Api(tags = {"物流运费合计记录表服务"})
@FeignClient(
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/finLogisticsReport",
        url = "${com.dtyunxi.tcbj.api:}"
)
public interface IFinLogisticsReportQueryApi {

    /**
    * 根据id查询物流运费合计记录表
    *
    * @param id 物流运费合计记录表id
    * @return   物流运费合计记录表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询物流运费合计记录表", notes = "根据id查询物流运费合计记录表")
    RestResponse<FinLogisticsReportRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 物流运费合计记录表分页数据
    *
    * @param reportReqDto   物流运费合计记录表查询条件
    * @return 物流运费合计记录表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(tags = "物流运费合计记录表服务",value = "物流运费合计记录表分页数据", notes = "根据filter查询条件查询物流运费合计记录表数据，filter=FinLogisticsReportReqDto")
    RestResponse<PageInfo<FinLogisticsReportRespDto>> queryByPage(@RequestBody FinLogisticReportReqDto reportReqDto);


    @PostMapping("/queryLogisticsCount")
    @ApiOperation(tags = "物流运费报表统计数据",value = "物流运费报表统计数据", notes = "物流运费报表统计数据")
    RestResponse<ReInsuranceBillCountDto> queryLogisticsCount(@RequestBody(required = false) FinLogisticReportReqDto reportReqDto);




    /**
     * 查询
     * @return
     */
    @GetMapping("/queryAnomalyCount")
    @ApiOperation(value = "物流运费异常统计数据", notes = "物流运费异常统计数据")
    RestResponse<Integer> queryAnomalyCount();



    /**
     * 物流运费合计记录表数据
     *
     * @param finLogisticsReportQueryListDto   出库单号,通知单号
     * @return 物流运费合计记录表数据
     */
    @PostMapping("/list")
    @ApiOperation(value = "物流运费合计记录表数据", notes = "物流运费合计记录表数据")
    RestResponse<List<FinLogisticsReportRespDto>> queryByList(@RequestBody FinLogisticsReportQueryListDto finLogisticsReportQueryListDto);

    /**
     * 物流费用明细报表数据分页查询（来源每日发货报表）
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/queryByPageForDailyDeliveryReport")
    @ApiOperation(value = "物流费用明细报表数据分页查询（来源每日发货报表）", notes = "物流费用明细报表数据分页查询（来源每日发货报表）")
    RestResponse<PageInfo<FinLogisticDetailRespDto>> queryByPageForDailyDeliveryReport(@RequestBody FinLogisticReportReqDto reqDto);

    /**
     * 物流费用明细报表数据分页查询异常统计
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/queryLogisticsAbnormalCountForDailyDeliveryReport")
    @ApiOperation(value = "物流费用明细报表数据分页查询异常统计", notes = "物流费用明细报表数据分页查询异常统计")
    RestResponse<ReInsuranceBillCountDto> queryLogisticsAbnormalCountForDailyDeliveryReport(@RequestBody FinLogisticReportReqDto reqDto);

    /**
     * 物流费用明细报表数据分页查询体积/重量/费用统计
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/queryLogisticsCountForDailyDeliveryReport")
    @ApiOperation(value = "物流费用明细报表数据分页查询体积/重量/费用统计", notes = "物流费用明细报表数据分页查询体积/重量/费用统计")
    RestResponse<ReInsuranceBillCountDto> queryLogisticsCountForDailyDeliveryReport(@RequestBody FinLogisticReportReqDto reqDto);

    @PostMapping("/queryDetailList")
    @ApiOperation(value = "查询物流费用明细数据", notes = "查询物流费用明细数据")
    RestResponse<List<FinLogisticDetailRespDto>> queryDetailList(@RequestBody FinLogisticDetailReqDto reqDto);
}
