package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;
import java.util.List;

/**
* 出库结果单Eo对象
*
* @author wude
* @since 2022-03-10
*/
@Getter
@Setter
@ApiModel(value = "OutResultOrderReqDto", description = "出库结果单Eo对象")
public class OutResultOrderReqDto extends BaseDto {


    @ApiModelProperty(name = "documentNo", value = "单号")
    private String documentNo;

    @ApiModelProperty(name = "documentNos", value = "单号集合")
    private List<String> documentNos;


    private List<String> externalOrderNos;

    private List<String> preOrderNoSet;

    /**
    *  单号
    */
    @ApiModelProperty(name = "orderNo", value = "单号")
    private String orderNo;



    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  单据状态,待定
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;
    /**
     *  发货逻辑仓库名称
     */
    @ApiModelProperty(name = "deliveryWarehouseName", value = "发货逻辑仓库名称")
    private String deliveryWarehouseName;
    /**
     *  收货逻辑仓库名称
     */
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货逻辑仓库名称")
    private String receiveWarehouseName;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(
            name = "createBeginTime",
            value = "创建开始时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(
            name = "createEndTime",
            value = "创建结束时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createEndTime;

    /** 单据类型：out-出库结果单，in-入库结果单 */
    @ApiModelProperty(name = "orderType",value = "单据类型：out-出库结果单，in-入库结果单")
    private String orderType;

    private String relevanceNo;

    /**
     * 物流商编码集合
     */
    private List<String>shippingCompanyCodes;

    private String warehouseCode;

    private String shippingCompanyCode;

    private String shippingType;

    @ApiModelProperty(name="businessTypeList", value = "业务类型集合")
    @JsonProperty("businessTypeList")
    private List<String> businessTypeList;


    @ApiModelProperty(name="documentStatusList", value = "出库状态")
    @JsonProperty("documentStatusList")
    private List<String> documentStatusList;
}
