package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 账期汇总出参
 * @since 2022-01-13 15:05
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AccountBillRespDto", description = "账期汇总出参")
public class AccountBillStatisticsRespDto extends ReportBrandBaseRespDto {

    @ApiModelProperty(name = "billNumbers", value = "账单笔数")
    private Integer billNumbers;

    @ApiModelProperty(name = "billAmount", value = "账单总金额")
    private BigDecimal billAmount;

    @ApiModelProperty(name = "usedReturnAmount", value = "已还金额")
    private BigDecimal usedReturnAmount;

    @ApiModelProperty(name = "outStandingAmount", value = "待还金额")
    private BigDecimal outStandingAmount;
}
