package com.dtyunxi.tcbj.api.dto.request;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author minyue
 * @description: 订单明细base
 * @since 2022-01-18 10:29
 */
@Data
public class OrderDetailBaseReqDto extends PageInfo<OrderDetailBaseReqDto> {

    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;

    @ApiModelProperty(name = "shopId", value = "所属店铺")
    private Long shopId;

    @ApiModelProperty(name = "batchNo", value = "批次")
    private String batchNo;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemType", value = "商品类型")
    private Integer itemType;

    @ApiModelProperty(name = "placeTimeStart", value = "下单开始时间")
    private String placeTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "下单结束时间")
    private String placeTimeEnd;

    @ApiModelProperty(name = "organizationIds", value = "组织")
    private List<Long> organizationIds;

//    @ApiModelProperty(name = "pageNum", value = "页数")
//    private Integer pageNum = 1;
//
//    @ApiModelProperty(name = "pageSize", value = "每页数量")
//    private Integer pageSize = 10;
}
