package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
* 销售订单表Eo对象
*
* @author haoxiao
* @since 2022-03-10
*/
@Data
@ApiModel(value = "SaleOrderReqDto", description = "销售订单表Eo对象")
public class SaleOrderReqDto extends BaseDto {
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     *  销售订单创建时间
     */
    @ApiModelProperty(name = "saleOrderCreateTimeStart", value = "销售订单创建时间开始")
    private Date saleOrderCreateTimeStart;
    /**
     *  销售订单创建时间
     */
    @ApiModelProperty(name = "saleOrderCreateTimeEnd", value = "销售订单创建时间结束")
    private Date saleOrderCreateTimeEnd;
    /**
     *  订单备注
     */
    @ApiModelProperty(name = "orderRemark", value = "订单备注")
    private String orderRemark;

    /**
     * 逻辑仓名称
     */
    @ApiModelProperty(name = "logicalWarehouseName", value = "逻辑仓名称")
    private String logicalWarehouseName;
    /**
     *  平台订单号
     */
    @ApiModelProperty(name = "orderNo", value = "单号（平台订单号/内部销售订单号）")
    private String orderNo;
    /**
     *  店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;
    /**
     *  店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
     *  订单类型 0-大B订单 1-积分订单 2-普通订单
     */
    @ApiModelProperty(name = "orderType", value = "订单类型 0-大B订单 1-积分订单 2-普通订单")
    private String orderType;
    /**
     *   订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
     */
    @ApiModelProperty(name = "orderSource", value = " 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private Integer orderSource;
    /**
     *  订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分
     */
    @ApiModelProperty(name = "saleOrderStatus", value = "订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分")
    private String saleOrderStatus;
    /**
     *  发货方
     */
    @ApiModelProperty(name = "sellerName", value = "发货方")
    private String sellerName;
    /**
     *  客户编码
     */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
     *  客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    /**
     *  收货人姓名
     */
    @ApiModelProperty(name = "deliveryName", value = "收货人姓名")
    private String deliveryName;
    /**
     *  收货人手机号
     */
    @ApiModelProperty(name = "deliveryPhone", value = "收货人手机号")
    private String deliveryPhone;
    /**
     *  收货地址
     */
    @ApiModelProperty(name = "detailAddress", value = "收货地址")
    private String detailAddress;

    /**
     *  更新时间开始
     */
    @ApiModelProperty(name = "updateTimeStart", value = "更新时间开始")
    private Date updateTimeStart;
    /**
     *  更新时间结束
     */
    @ApiModelProperty(name = "updateTimeEnd", value = "更新时间结束")
    private Date updateTimeEnd;
    /**
     *  承运商/物流公司
     */
    @ApiModelProperty(name = "logisticsCompany", value = "承运商/物流公司")
    private String logisticsCompany;
    /**
     *  拦截信息
     */
    @ApiModelProperty(name = "interceptInfo", value = "拦截信息")
    private String interceptInfo;
    /**
     *  创建人
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    /**
     *  发货时间开始
     */
    @ApiModelProperty(name = "deliveryTimeStart", value = "发货时间开始")
    private Date deliveryTimeStart;
    /**
     *  发货时间结束
     */
    @ApiModelProperty(name = "deliveryTimeEnd", value = "发货时间结束")
    private Date deliveryTimeEnd;

    @ApiModelProperty(name ="orderLevel",value = "订单级别（0原、1主、2子）")
    private Integer orderLevel;
    

    @ApiModelProperty(name ="saleChannel",value = "经销渠道")
    private String saleChannel;

    /**
     *   订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
     */
    @ApiModelProperty(name = "orderSourceList", value = " 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private List<Integer> orderSourceList;

    @ApiModelProperty(name = "saleOrderStatusList", value = "订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分")
    private List<String> saleOrderStatusList;

    @ApiModelProperty(name ="receiveDeliveryType",value = "收发货状态")
    private String receiveDeliveryType;

    @ApiModelProperty(name ="mainOrderNo",value = "主单号")
    private String mainOrderNo;

    @ApiModelProperty(name ="orderNoList",value = "订单状态集合")
    private List<String> orderNoList;

    @ApiModelProperty( name = "cityCode",value = "市编码")
    private String cityCode;

    @ApiModelProperty( name = "districtCode",value = "区编码")
    private String districtCode;

    @ApiModelProperty( name = "provinceCode",value = "省编码")
    private String provinceCode;

    @ApiModelProperty( name = "platformParentOrderNo",value = "父级平台单号")
    private String platformParentOrderNo;


    /**
     * 是否对接财务中台或eas平台 0否;1是，默认1
     */
    @ApiModelProperty(name = "ifButtThirdParty",value ="是否对接财务中台或eas平台 0否;1是，默认1" )
    private Integer ifButtThirdParty;

    @ApiModelProperty(name = "orderBizType", value = "订单业务类型  0:信控前置（不需要eas审批订单自动发货）1:信控后置（需要到eas系统审核订单发货）")
    private Integer orderBizType;

    /**
     * 指定供货仓
     */
    @ApiModelProperty(name = "storagePlace",value = "指定供货仓")
    private String storagePlaceName;

    /**
     *  物理仓名称
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;

    /**
     * 串码验证结果 0-未读取;1-读码异常;2-读码成功;默认0
     */
    @ApiModelProperty(name = "stringCodeResult",value = "串码验证结果 0-未读取;1-读码异常;2-读码成功;默认0")
    private String stringCodeResult;

    /**
     *  拆分平台单号，-+拆分级别
     */
    @ApiModelProperty(name = "splitPlatformNo",value = "拆分平台单号，-+拆分级别")
    private String splitPlatformNo;

    /**
     * eas单号
     */
    @ApiModelProperty(name = "easOrderNo",value = "eas单号/出库单号")
    private String easOrderNo;

    @ApiModelProperty(name="orderTypeList", value = "订单类型")
    private List<String> orderTypeList;


    /**
     * eas单号
     */
    @ApiModelProperty(name = "easOrderNoList",value = "eas单号/出库单号")
    private List<String> easOrderNoList;

    @ApiModelProperty(
            name = "interceptInfoFlag",
            value = "拦截信息标识（0:否，1:是）"
    )
    private String interceptInfoFlag;


    /**
     *  是否接受拆单 0-否 1-是
     */
    @ApiModelProperty(name = "allowSplitFlag", value = "是否接受拆单 0-否 1-是")
    private Integer allowSplitFlag;

    /**
     *  订单级别：0-原 1-主 2-子
     */
    @ApiModelProperty(name = "orderLevelList", value = "订单级别：0-原 1-主 2-子")
    private List<Integer> orderLevelList;

    @ApiModelProperty(
            name = "physicsWarehouseCode",
            value = "物理仓编码"
    )
    private String physicsWarehouseCode;

    @ApiModelProperty(
            name = "easVerifyStatus",
            value = "EAS验证状态"
    )
    private String easVerifyStatus;

    @ApiModelProperty(
            name = "assignStatus",
            value = "订单指派状态"
    )
    private String assignStatus;

    private List<String> excludeOrderTypeList;

    private String logisticsNo;
    @ApiModelProperty(name="stringCodeResultList", value = "串码验证结果")
    private List<String> stringCodeResultList;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    @ApiModelProperty(
            name = "sellerRemarkFlag",
            value = "商家备注标识（0:否，1:是）"
    )
    private String sellerRemarkFlag;

    @ApiModelProperty(name="interceptInfo", value = "商家备注")
    private String sellerRemark;

    @ApiModelProperty( name = "goodsSku",value = "商品长编码")
    private String goodsSku;

    /**
     *  挂起状态：0-未挂起 1-已挂起 2-挂起失败
     */
    @ApiModelProperty(name = "lockStatus", value = "挂起状态：0-未挂起 1-已挂起 2-挂起失败")
    private Integer lockStatus;
    private List<String> excludeSaleOrderStatusList;

    @ApiModelProperty(name = "easVerifyStatusList",value = "非药业财务前置单eas验证状态，0 未验证，1验证通过，默认0")
    private List<Integer> easVerifyStatusList;

    @ApiModelProperty(name="bizDateStart", value = "业务日期开始")
    @JsonProperty("bizDateStart")
    private Date bizDateStart;


    @ApiModelProperty(name="bizDateEnd", value = "业务日期结束")
    @JsonProperty("bizDateEnd")
    private Date bizDateEnd;

    @ApiModelProperty(name="tagCodeList", value = "标签编码集合")
    @JsonProperty("tagCodeList")
    private List<String> tagCodeList;


    /**
     *  订单子状态 WAIT_PICK_UNLOCK-待配货未锁定  WAIT_PICK_LOCK_UN_APPOINT-已锁定待指派PART_OUT_DELIVERY-部分出库 ALL_OUT_DELIVERY-全部出库
     */
    @JsonProperty("secondOrderStatus")
    @ApiModelProperty(name = "secondOrderStatus", value = "订单子状态 WAIT_PICK_UNLOCK-待配货未锁定  WAIT_PICK_LOCK_UN_APPOINT-已锁定待指派PART_OUT_DELIVERY-部分出库 ALL_OUT_DELIVERY-全部出库")
    private String secondOrderStatus;

    /**
     * 区域名称
     */
    @ApiModelProperty(name = "regionName", value = "区域名称")
    private String regionName;
    /**
     * 渠道仓编码集合
     */
    @ApiModelProperty(name = "channelWarehouseCodeList",value = "渠道仓编码集合")
    private List<String> channelWarehouseCodeList;
    /**
     * 供货仓编码集合
     */
    @ApiModelProperty(name = "storagePlaceList",value = "供货仓编码集合")
    private List<String> storagePlaceList;

    /**
     * eas财审时间开始
     */
    @ApiModelProperty(name = "easVerifyTimeStart",value = "eas财审时间开始")
    private String easVerifyTimeStart;

    /**
     * eas财审时间结束
     */
    @ApiModelProperty(name = "easVerifyTimeEnd",value = "eas财审时间结束")
    private String easVerifyTimeEnd;
    /**
     * 发货状态 undelivered 未发货；delivered 已发货
     */
    @ApiModelProperty(name = "deliveryStauts",value = "发货状态 undelivered 未发货；delivered 已发货")
    private String deliveryStauts;

    /**
     * 成本中心名称
     */
    @ApiModelProperty(name = "costCenterName",value = "成本中心名称")
    private String costCenterName;

    /**
     * 超期状态
     */
    @ApiModelProperty( name = "overdueStatus",value = "超期状态 no_delivery:超期未发；no_received:超期未收")
    private String overdueStatus;


    /**
     * 是否预占库存 0 ：否；1：是
     */
    @ApiModelProperty( name = "preemptionStock",value = "是否预占库存 0 ：否；1：是")
    private Integer preemptionStockFalg;

    @ApiModelProperty(name="shippingNo", value = "快递单号")
    private String shippingNo;

    @ApiModelProperty(name = "consignmentNo", value = "物流单号")
    private String consignmentNo;
    @ApiModelProperty(name = "transferWmsConsignmentNo", value = "转运托运单号")
    private String transferWmsConsignmentNo;

    @ApiModelProperty(name = "wmsConsignmentNo", value = "托运单号")
    private String wmsConsignmentNo;

    @ApiModelProperty(name = "carrierType", value = "承运方式")
    private String carrierType;

    @ApiModelProperty(name = "carrierName", value = "承运商")
    private String carrierName;

    @ApiModelProperty(name = "consignmentDeliveryTimeStart", value = "发货时间开始")
    private String consignmentDeliveryTimeStart;

    @ApiModelProperty(name = "consignmentDeliveryTimeEnd", value = "发货时间结束")
    private String consignmentDeliveryTimeEnd;

    @ApiModelProperty(name = "planArriveTimeStart", value = "预计到达时间开始")
    private String planArriveTimeStart;

    @ApiModelProperty(name = "planArriveTimeEnd", value = "预计到达时间结束")
    private String planArriveTimeEnd;

    @ApiModelProperty(name = "customerIdList", value = "客户id集合")
    private List<Long> customerIdList;

    @ApiModelProperty(name = "organizationIdList", value = "组织id集合")
    private List<Long> organizationIdList;

    @ApiModelProperty( name = "batchInverted",value = "是否批次倒挂 0 ：否；1：是")
    private Integer batchInverted;

    @ApiModelProperty(name = "allotType", value = "调拨方式")
    private String allotType;

    @ApiModelProperty(name = "allotTypeList", value = "调拨方式")
    private List<String> allotTypeList;

    @ApiModelProperty(name = "allotOutWarehouseCode", value = "调出仓编码")
    private String allotOutWarehouseCode;

    @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓编码")
    private String allotInWarehouseCode;

    @ApiModelProperty(name = "ifSourceWarehouseSpilt", value = "是否寻源拆单")
    private Integer ifSourceWarehouseSpilt;


}
