package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillRespDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillSumDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 保费账单表服务接口
*
* @author lshaowu
* @since 2022-07-18
*/
@Api(tags = {"保费账单表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IReInsuranceBillQueryApi",
    name = "tcbj-center-report",
    path = "/v1/reInsuranceBill",
    url = "${tcbj.center.report.api:}"
)
public interface IReInsuranceBillQueryApi {

    /**
    * 根据id查询保费账单表
    *
    * @param id 保费账单表id
    * @return   保费账单表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询保费账单表", notes = "根据id查询保费账单表")
    RestResponse<ReInsuranceBillRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 保费账单表分页数据
    *
    * @param filter   保费账单表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 保费账单表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "保费账单表分页数据", notes = "根据filter查询条件查询保费账单表数据，filter=ReInsuranceBillReqDto")
    RestResponse<PageInfo<ReInsuranceBillRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    @PostMapping("/queryBillingCount")
    @ApiOperation(value = "保费账单统计数据", notes = "保费账单统计数据")
    RestResponse<List<ReInsuranceBillCountDto>> queryBillingCount(@RequestBody(required = false) ReInsuranceBillReqDto reInsuranceBillReqDto);

    @PostMapping("/queryBillingSum")
    @ApiOperation(value = "保费账单统计单票总价值和保费", notes = "保费账单统计单票总价值和保费")
    RestResponse<ReInsuranceBillSumDto> queryBillingSum(@RequestBody(required = false) ReInsuranceBillReqDto reInsuranceBillReqDto);

    @PostMapping("/queryPremiumCount")
    @ApiOperation(value = "保费明细统计数据", notes = "保费明细统计数据")
    RestResponse<ReInsuranceBillCountDto> queryPremiumCount(@RequestBody(required = false) ReInsurancePremiumReqDto reInsurancePremiumReqDto);

    /**
     * 保费账单更新归档标识
     * @param updateReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "保费账单更新归档标识", notes = "保费账单更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

}
