package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@ApiModel("调拨单明细分页查询EXT响应参数")
public class TransferOrderReportExtRespDto {
    
    @ApiModelProperty("调拨单号")
    private String transferOrderNo;
    
    @ApiModelProperty("渠道单号")
    private String platformOrderNo;
    
    @ApiModelProperty("调出组织")
    private String outOrganization;

    @ApiModelProperty("调出组织Id")
    private Long outOrganizationId;

    @ApiModelProperty("调出组织Code")
    private String outOrganizationCode;

    @ApiModelProperty("调入组织")
    private String inOrganization;

    @ApiModelProperty("调入组织Id")
    private Long inOrganizationId;

    @ApiModelProperty("调入组织Code")
    private String inOrganizationCode;

    @ApiModelProperty("调出仓")
    private String outLogicWarehouseName;

    @ApiModelProperty("调出仓Code")
    private String outLogicWarehouseCode;

    @ApiModelProperty("调入仓")
    private String inLogicWarehouseName;

    @ApiModelProperty("调入仓Code")
    private String inLogicWarehouseCode;

    @ApiModelProperty("创建时间")
    private Date createTime;
    
    @ApiModelProperty("发货时间")
    private Date deliveryTime;
    
    @ApiModelProperty("调拨单状态")
    private String orderStatus;

    @ApiModelProperty("产品编号（短编码）")
    private String code;

    @ApiModelProperty("产品编号（长编码）")
    private String longCode;
    
    @ApiModelProperty("产品名称")
    private String cargoName;
    
    @ApiModelProperty("规格")
    private String specification;
    
    @ApiModelProperty("批次号")
    private String batch;
    
    @ApiModelProperty("生产日期")
    private Date produceTime;
    
    @ApiModelProperty("到期日期")
    private Date expireTime;
    
//    @ApiModelProperty("条码")
//    private String barcode;
    
    @ApiModelProperty("数量")
    private Integer quantity;

    @ApiModelProperty("条码")
    private String barCode;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("类型，1-产品，2-赠品，3-物料")
    private String type;

    @ApiModelProperty("托运单")
    private String consignmentNo;

    @ApiModelProperty("礼盒信息")
    private List<GiftPackageExtDto> giftPackageInfoExtDtoList;

    @ApiModelProperty("质检报告信息")
    private List<QualityInspectionDataRespDto> qualityInspectionDataRespDtoList;

    @ApiModelProperty("sap单号")
    private String sapOrderNo;

    @ApiModelProperty("明细ID")
    private Long detailId;

    @ApiModelProperty("客户地址")
    private String address;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("重量")
    private BigDecimal totalWeight;

    @ApiModelProperty("体积")
    private BigDecimal totalVolume;

    @ApiModelProperty("总箱数")
    private BigDecimal totalCartons;

    @ApiModelProperty("拼箱数")
    private BigDecimal mergeQuantity;

}