package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author buqi
 * @since 2024/12/04
 */
@Data
@ApiModel(value = "ExpressBillRespDto", description = "快递账单Eo对象")
public class ExpressBillRespDto extends BaseRespDto {
    /**
     *  主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    /**
     *  记账月份
     */
    @ApiModelProperty(name = "bookkeepingMonth", value = "记账月份")
    private String bookkeepingMonth;
    /**
     *  物理仓编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
     *  物理仓名称
     */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
     * 计费组织
     */
    @ApiModelProperty(name = "billingOrg", value = "计费组织")
    private String billingOrg;
    /**
     * 计费组织编码
     */
    @ApiModelProperty(name = "billingOrgCode", value = "计费组织编码")
    private String billingOrgCode;
    /**
     *  物流公司编码
     */
    @ApiModelProperty(name = "logisticCode", value = "物流公司编码")
    private String logisticCode;
    /**
     *  物流公司名称
     */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司名称")
    private String logisticCompany;
    /**
     *  承运方式
     */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
     * 月发票数
     */
    @ApiModelProperty(name = "totalMonthInvoice", value = "月发票数")
    private BigDecimal totalMonthInvoice;
    /**
     * 快递费合计
     */
    @ApiModelProperty(name = "totalFreight", value = "快递费合计")
    private BigDecimal totalFreight;
}
