package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 仓储账单明细表服务接口
*
* @author by_liusong
* @since 2022-07-15
*/
@Api(tags = {"仓储账单明细表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IStorageChargeDetailQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/storageChargeDetail",
    url = "${tcbj.center.report.api:}"
)
public interface IStorageChargeDetailQueryApi {

    /**
    * 根据id查询仓储账单明细表
    *
    * @param id 仓储账单明细表id
    * @return   仓储账单明细表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓储账单明细表", notes = "根据id查询仓储账单明细表")
    RestResponse<StorageChargeDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 仓储账单明细表分页数据
    *
    * @param filter   仓储账单明细表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 仓储账单明细表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "仓储账单明细表分页数据", notes = "根据filter查询条件查询仓储账单明细表数据，filter=StorageChargeDetailReqDto")
    RestResponse<PageInfo<StorageChargeDetailRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @GetMapping("/importPage")
    @ApiOperation(value = "仓储账单明细表分页数据导入查询", notes = "仓储账单明细表分页数据导入查询")
    RestResponse<List<StorageChargeDetailRespDto>> importPage(@RequestBody List<StorageChargeDetailReqDto> queryDtoList);

    /**
     * 仓储明细更新归档标识
     * @param updateReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "仓储明细更新归档标识", notes = "仓储明细更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

}
