package com.dtyunxi.tcbj.api.query.es;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.es.*;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author xiaoyuan
 * @description: 库存相关的报表
 * @since 2022-08-21 16:00
 */
@Api(tags = {"报表中心：库存相关的报表"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/inventory/es",
        url = "${tcbj.center.report.api:}"
)
public interface InventoryEsReportQueryApi {

    @ApiOperation(
            tags = {"finishedGoodsInventory/otherOut"},
            value = "其他出入库单列表",
            nickname = "getOtherOutList",
            notes = "")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/otherOutList",
            produces = {"application/json"},
            consumes = {"application/json"}
    )
    RestResponse<PageInfo<CsOtherStorageOrderRespVo>> getOtherOutList(
            @ApiParam(value = "") @Valid @RequestBody(required = false) EsOtherStorageOrderListPageParams getOtherOutListBody);

    @ApiOperation(
            tags = {"finishedGoodsInventory/otherOut"},
            value = "其他出入库单状态数量统计",
            nickname = "otherStorageOrderStatusCount",
            notes = "")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/otherStorageOrderStatusCount",
            produces = {"application/json"},
            consumes = {"application/json"}
    )
    RestResponse<List<InPlannedOrderStatusCountRespDto>> otherStorageOrderStatusCount(
            @ApiParam(value = "") @Valid @RequestBody(required = false) EsOtherStorageOrderListPageParams getOtherOutListBody);

    /**
     * 出库通知单分页数据
     *
     * @param filter 出库通知单查询条件
     * @return 出库通知单分页数据
     */
    @PostMapping("/queryOutNoticeOrderPage")
    @ApiOperation(value = "出库通知单分页数据", notes = "根据filter查询条件查询出库通知单数据，filter=EsGetOutNoticeOrderListPageParams")
    RestResponse<PageInfo<OutNoticeOrderVO>> queryOutNoticeOrderPage(@RequestBody EsOutNoticeOrderListPageParams filter);

    @ApiOperation(value = "库存操作流水列表查询", notes = "库存操作流水列表查询")
    @PostMapping(value = "/inventoryOperateLog", produces = "application/json")
    RestResponse<PageInfo<EsInventoryOperateLogVO>> queryInventoryOperateLogListPage(@RequestBody EsInventoryOperateLogListPageParams dto);

    @ApiOperation(value = "入库通知单列表查询", notes = "入库通知单列表查询")
    @PostMapping(value = "/noticeOrder", produces = "application/json")
    RestResponse<PageInfo<InNoticeOrderVO>> queryNoticeOrderPage(@RequestBody GetNoticeOrderPageParams dto);


    @ApiOperation(
            tags = { "finishedGoodsInventory/purchaseOrder" },
            value = "成品入库单据列表")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/list",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<PageInfo<PurchaseOrderVO>> getPurchaseOrderListPage(
            @ApiParam(value = "") @Valid @RequestBody(required = false) GetPurchaseOrderListPageParams getPurchaseOrderListPageParams);

    @ApiOperation(
            tags = { "finishedGoodsInventory/purchaseOrder/inPlannedOrderStatusCount" },
            value = "采购订单订单状态数量统计")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/inPlannedOrderStatusCount",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<List<InPlannedOrderStatusCountRespDto>> inPlannedOrderStatusCount(
            @ApiParam(value = "") @Valid @RequestBody(required = false) GetPurchaseOrderListPageParams getPurchaseOrderListPageParams);


    @ApiOperation(
            tags = { "finishedGoodsInventory/purchaseReturnOrder" },
            value = "成品出库列表")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/purchaseReturnOrder",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<PageInfo<PurchaseReturnOrderVO>> getPurchaseReturnOrderListPage(
            @ApiParam(value = "") @Valid @RequestBody(required = false) GetPurchaseReturnOrderListPageParams getPurchaseReturnOrderListPageParams
    );

    @ApiOperation(
            tags = { "finishedGoodsInventory/purchaseOrder/outPlannedOrderStatusCount" },
            value = "采购退货订单订单状态数量统计")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/outPlannedOrderStatusCount",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<List<InPlannedOrderStatusCountRespDto>> outPlannedOrderStatusCount(@ApiParam(value = "") @Valid @RequestBody(required = false) GetPurchaseReturnOrderListPageParams getPurchaseReturnOrderListPageParams);

    @ApiOperation(
            tags = { "finishedGoodsInventory/queryProductOrderListPage" },
            value = "生产订单列表")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/queryProductOrderListPage",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<PageInfo<ProductOrderVO>> queryProductOrderListPage(
            @ApiParam(value = "") @Valid @RequestBody(required = false) ProductOrderLisReq productOrderLisReq
    );

    @ApiOperation(
            tags = { "finishedGoodsInventory/queryProductOrderListPage" },
            value = "生产订单状态数量统计")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/productOrderStatusCount",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<List<InPlannedOrderStatusCountRespDto>> productOrderStatusCount(@ApiParam(value = "") @Valid @RequestBody(required = false) ProductOrderLisReq productOrderLisReq);

    @ApiOperation(
            tags = { "finishedGoodsInventory/queryMaterialsOrderListPage" },
            value = "生产领料订单列表")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/queryMaterialsOrderListPage",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<PageInfo<ProductOrderVO>> queryMaterialsOrderListPage(
            @ApiParam(value = "") @Valid @RequestBody(required = false) MaterialsOrderLisReq materialsOrderLisReq
    );

    @ApiOperation(
            tags = { "finishedGoodsInventory/materialsOrderStatusCount" },
            value = "生产领料状态数量统计")
    @RequestMapping(
            method = RequestMethod.POST,
            value = "/v1/finishedGoodsInventory/materialsOrderStatusCount",
            produces = { "application/json" },
            consumes = { "application/json" }
    )
    RestResponse<List<InPlannedOrderStatusCountRespDto>> materialsOrderStatusCount(@ApiParam(value = "") @Valid @RequestBody(required = false) MaterialsOrderLisReq materialsOrderLisReq);



    @PostMapping("/modifyOtherOut")
    @ApiOperation(value = "修改其他出库单", notes = "修改其他出库单")
    RestResponse<Void> modifyOtherOut(@RequestBody CsOtherStorageOrderRespVo csOtherStorageOrderRespVo);

    /**
     * 根据id查询业务类型表
     *
     * @param id 业务类型表id
     * @return 业务类型表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询其他出库单表", notes = "根据id查询其他出库单表")
    RestResponse<CsOtherStorageOrderRespVo> queryById(@PathVariable("id") Long id);

}

