/**
 * @(#)LockOrderQueryDto.java 1.0 2022/05/30 15:48
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wenyi
 * @Description LockOrderQueryDto
 * @Date: 2022/05/30 15:48
 * @since 1.0.0
 */
@ApiModel(value = "lockOrderQueryDto", description = "查询Dto")
public class LockOrderQueryDto implements Serializable {

    /**
     * 逻辑仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库编码")
    private String warehouseCode;
    /**
     * 逻辑仓库名称
     */
    @ApiModelProperty(name = "warehouseName", value = "逻辑仓库名称")
    private String warehouseName;
    /**
     * 仓库属性 com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehousePropertyEnum
     */
    @ApiModelProperty(name = "warehouseProperty", value = "仓库属性，成品-finished_product   半成品-semi_finished_product   专柜-shoppe    第三方-third_party   促销物料-promotionp_boring")
    private String warehouseProperty;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
     * 货品名称
     */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
     * 货品货号
     */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
     * 批次
     */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
     * 当前锁库数量
     */
    @ApiModelProperty(name = "currentLockQuantity", value = "当前锁库数量")
    private BigDecimal currentLockQuantity;
    /**
     * 人工锁库次数
     */
    @ApiModelProperty(name = "number", value = "人工锁库次数")
    private Integer number;
    /**
     * 锁库原因
     */
    @ApiModelProperty(name = "remark", value = "锁库原因")
    private String remark;
    /**
     * 商品类型：1-产品 2-赠品 3-促销物料
     */
    @ApiModelProperty(name = "itemType", value = "商品类型：1-产品 2-赠品 3-促销物料")
    private Long itemType;
    /**
     * 库存组织
     */
    @ApiModelProperty(name = "organizationName", value = "库存组织")
    private String organizationName;
    /**
     * 是否临期
     */
    @ApiModelProperty(name = "isNearOverdue", value = "是否临期：1是，0否")
    private Integer isNearOverdue;
    /**
     * 是否锁库
     */
    @ApiModelProperty(name = "isLockInventory", value = "是否锁库：1是，0否")
    private Integer isLockInventory;
    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseProperty() {
        return warehouseProperty;
    }

    public void setWarehouseProperty(String warehouseProperty) {
        this.warehouseProperty = warehouseProperty;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getCurrentLockQuantity() {
        return currentLockQuantity;
    }

    public void setCurrentLockQuantity(BigDecimal currentLockQuantity) {
        this.currentLockQuantity = currentLockQuantity;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getItemType() {
        return itemType;
    }

    public void setItemType(Long itemType) {
        this.itemType = itemType;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getIsNearOverdue() {
        return isNearOverdue;
    }

    public void setIsNearOverdue(Integer isNearOverdue) {
        this.isNearOverdue = isNearOverdue;
    }

    public Integer getIsLockInventory() {
        return isLockInventory;
    }

    public void setIsLockInventory(Integer isLockInventory) {
        this.isLockInventory = isLockInventory;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

}