package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.ExpressCostReportRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 快递费用报表服务接口
 *
 * @author 天泽
 * @since 2022-11-17
 */
@Api(tags = {"快递费用报表服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IExpressCostReportQueryApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/express/cost/report",
        url = "${tcbj.center.report.api:}"
)
public interface IExpressCostReportQueryApi {

    /**
     * 根据id查询快递费用报表
     *
     * @param id 快递费用报表id
     * @return 快递费用报表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询快递费用报表", notes = "根据id查询快递费用报表")
    RestResponse<ExpressCostReportRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 快递费用报表分页数据
     *
     * @param filter   快递费用报表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 快递费用报表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "快递费用报表分页数据", notes = "根据filter查询条件查询快递费用报表数据，filter=ExpressCostReportReqDto")
    RestResponse<PageInfo<ExpressCostReportRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                 @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                 @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
